% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpn_tunnel_options}
\alias{ec2_modify_vpn_tunnel_options}
\title{Modifies the options for a VPN tunnel in an Amazon Web Services
Site-to-Site VPN connection}
\usage{
ec2_modify_vpn_tunnel_options(
  VpnConnectionId,
  VpnTunnelOutsideIpAddress,
  TunnelOptions,
  DryRun = NULL,
  SkipTunnelReplacement = NULL
)
}
\arguments{
\item{VpnConnectionId}{[required] The ID of the Amazon Web Services Site-to-Site VPN connection.}

\item{VpnTunnelOutsideIpAddress}{[required] The external IP address of the VPN tunnel.}

\item{TunnelOptions}{[required] The tunnel options to modify.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SkipTunnelReplacement}{Choose whether or not to trigger immediate tunnel replacement.

Valid values: \code{True} | \code{False}}
}
\description{
Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify multiple options for a tunnel in a single request, but you can only modify one tunnel at a time. For more information, see \href{https://docs.aws.amazon.com/vpn/latest/s2svpn/VPNTunnels.html}{Site-to-Site VPN tunnel options for your Site-to-Site VPN connection} in the \emph{Amazon Web Services Site-to-Site VPN User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_vpn_tunnel_options/} for full documentation.
}
\keyword{internal}
