% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrserverless_operations.R
\name{emrserverless_update_application}
\alias{emrserverless_update_application}
\title{Updates a specified application}
\usage{
emrserverless_update_application(
  applicationId,
  clientToken,
  initialCapacity = NULL,
  maximumCapacity = NULL,
  autoStartConfiguration = NULL,
  autoStopConfiguration = NULL,
  networkConfiguration = NULL,
  architecture = NULL,
  imageConfiguration = NULL,
  workerTypeSpecifications = NULL
)
}
\arguments{
\item{applicationId}{[required] The ID of the application to update.}

\item{clientToken}{[required] The client idempotency token of the application to update. Its value
must be unique for each request.}

\item{initialCapacity}{The capacity to initialize when the application is updated.}

\item{maximumCapacity}{The maximum capacity to allocate when the application is updated. This
is cumulative across all workers at any given point in time during the
lifespan of the application. No new resources will be created once any
one of the defined limits is hit.}

\item{autoStartConfiguration}{The configuration for an application to automatically start on job
submission.}

\item{autoStopConfiguration}{The configuration for an application to automatically stop after a
certain amount of time being idle.}

\item{networkConfiguration}{}

\item{architecture}{The CPU architecture of an application.}

\item{imageConfiguration}{The image configuration to be used for all worker types. You can either
set this parameter or \code{imageConfiguration} for each worker type in
\code{WorkerTypeSpecificationInput}.}

\item{workerTypeSpecifications}{The key-value pairs that specify worker type to
\code{WorkerTypeSpecificationInput}. This parameter must contain all valid
worker types for a Spark or Hive application. Valid worker types include
\code{Driver} and \code{Executor} for Spark applications and \code{HiveDriver} and
\code{TezTask} for Hive applications. You can either set image details in
this parameter for each worker type, or in \code{imageConfiguration} for all
worker types.}
}
\description{
Updates a specified application. An application has to be in a stopped or created state in order to be updated.

See \url{https://www.paws-r-sdk.com/docs/emrserverless_update_application/} for full documentation.
}
\keyword{internal}
