% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_create_application_version}
\alias{elasticbeanstalk_create_application_version}
\title{Creates an application version for the specified application}
\usage{
elasticbeanstalk_create_application_version(
  ApplicationName,
  VersionLabel,
  Description = NULL,
  SourceBuildInformation = NULL,
  SourceBundle = NULL,
  BuildConfiguration = NULL,
  AutoCreateApplication = NULL,
  Process = NULL,
  Tags = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The name of the application. If no application is found with this name,
and \code{AutoCreateApplication} is \code{false}, returns an
\code{InvalidParameterValue} error.}

\item{VersionLabel}{[required] A label identifying this version.

Constraint: Must be unique per application. If an application version
already exists with this label for the specified application, AWS
Elastic Beanstalk returns an \code{InvalidParameterValue} error.}

\item{Description}{A description of this application version.}

\item{SourceBuildInformation}{Specify a commit in an AWS CodeCommit Git repository to use as the
source code for the application version.}

\item{SourceBundle}{The Amazon S3 bucket and key that identify the location of the source
bundle for this version.

The Amazon S3 bucket must be in the same region as the environment.

Specify a source bundle in S3 or a commit in an AWS CodeCommit
repository (with \code{SourceBuildInformation}), but not both. If neither
\code{SourceBundle} nor \code{SourceBuildInformation} are provided, Elastic
Beanstalk uses a sample application.}

\item{BuildConfiguration}{Settings for an AWS CodeBuild build.}

\item{AutoCreateApplication}{Set to \code{true} to create an application with the specified name if it
doesn't already exist.}

\item{Process}{Pre-processes and validates the environment manifest (\code{env.yaml}) and
configuration files (\verb{*.config} files in the \code{.ebextensions} folder) in
the source bundle. Validating configuration files can identify issues
prior to deploying the application version to an environment.

You must turn processing on for application versions that you create
using AWS CodeBuild or AWS CodeCommit. For application versions built
from a source bundle in Amazon S3, processing is optional.

The \code{Process} option validates Elastic Beanstalk configuration files. It
doesn't validate your application's configuration files, like proxy
server or Docker configuration.}

\item{Tags}{Specifies the tags applied to the application version.

Elastic Beanstalk applies these tags only to the application version.
Environments that use the application version don't inherit the tags.}
}
\description{
Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:

See \url{https://www.paws-r-sdk.com/docs/elasticbeanstalk_create_application_version/} for full documentation.
}
\keyword{internal}
