% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_start_job_run}
\alias{emrcontainers_start_job_run}
\title{Starts a job run}
\usage{
emrcontainers_start_job_run(
  name = NULL,
  virtualClusterId,
  clientToken,
  executionRoleArn = NULL,
  releaseLabel = NULL,
  jobDriver = NULL,
  configurationOverrides = NULL,
  tags = NULL,
  jobTemplateId = NULL,
  jobTemplateParameters = NULL,
  retryPolicyConfiguration = NULL
)
}
\arguments{
\item{name}{The name of the job run.}

\item{virtualClusterId}{[required] The virtual cluster ID for which the job run request is submitted.}

\item{clientToken}{[required] The client idempotency token of the job run request.}

\item{executionRoleArn}{The execution role ARN for the job run.}

\item{releaseLabel}{The Amazon EMR release version to use for the job run.}

\item{jobDriver}{The job driver for the job run.}

\item{configurationOverrides}{The configuration overrides for the job run.}

\item{tags}{The tags assigned to job runs.}

\item{jobTemplateId}{The job template ID to be used to start the job run.}

\item{jobTemplateParameters}{The values of job template parameters to start a job run.}

\item{retryPolicyConfiguration}{The retry policy configuration for the job run.}
}
\description{
Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

See \url{https://www.paws-r-sdk.com/docs/emrcontainers_start_job_run/} for full documentation.
}
\keyword{internal}
