% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_container_service}
\alias{lightsail_update_container_service}
\title{Updates the configuration of your Amazon Lightsail container service,
such as its power, scale, and public domain names}
\usage{
lightsail_update_container_service(
  serviceName,
  power = NULL,
  scale = NULL,
  isDisabled = NULL,
  publicDomainNames = NULL,
  privateRegistryAccess = NULL
)
}
\arguments{
\item{serviceName}{[required] The name of the container service to update.}

\item{power}{The power for the container service.

The power specifies the amount of memory, vCPUs, and base monthly cost
of each node of the container service. The \code{power} and \code{scale} of a
container service makes up its configured capacity. To determine the
monthly price of your container service, multiply the base price of the
\code{power} with the \code{scale} (the number of nodes) of the service.

Use the
\code{\link[=lightsail_get_container_service_powers]{get_container_service_powers}}
action to view the specifications of each power option.}

\item{scale}{The scale for the container service.

The scale specifies the allocated compute nodes of the container
service. The \code{power} and \code{scale} of a container service makes up its
configured capacity. To determine the monthly price of your container
service, multiply the base price of the \code{power} with the \code{scale} (the
number of nodes) of the service.}

\item{isDisabled}{A Boolean value to indicate whether the container service is disabled.}

\item{publicDomainNames}{The public domain names to use with the container service, such as
\code{example.com} and \code{www.example.com}.

You can specify up to four public domain names for a container service.
The domain names that you specify are used when you create a deployment
with a container configured as the public endpoint of your container
service.

If you don't specify public domain names, then you can use the default
domain of the container service.

You must create and validate an SSL/TLS certificate before you can use
public domain names with your container service. Use the
\code{\link[=lightsail_create_certificate]{create_certificate}} action to create a
certificate for the public domain names you want to use with your
container service.

You can specify public domain names using a string to array map as shown
in the example later on this page.}

\item{privateRegistryAccess}{An object to describe the configuration for the container service to
access private container image repositories, such as Amazon Elastic
Container Registry (Amazon ECR) private repositories.

For more information, see Configuring access to an Amazon ECR private
repository for an Amazon Lightsail container service in the \emph{Amazon
Lightsail Developer Guide}.}
}
\description{
Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.

See \url{https://www.paws-r-sdk.com/docs/lightsail_update_container_service/} for full documentation.
}
\keyword{internal}
