% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_carrier_gateways}
\alias{ec2_describe_carrier_gateways}
\title{Describes one or more of your carrier gateways}
\usage{
ec2_describe_carrier_gateways(
  CarrierGatewayIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{CarrierGatewayIds}{One or more carrier gateway IDs.}

\item{Filters}{One or more filters.
\itemize{
\item \code{carrier-gateway-id} - The ID of the carrier gateway.
\item \code{state} - The state of the carrier gateway (\code{pending} | \code{failed} |
\code{available} | \code{deleting} | \code{deleted}).
\item \code{owner-id} - The Amazon Web Services account ID of the owner of the
carrier gateway.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC associated with the carrier gateway.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of your carrier gateways.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_carrier_gateways/} for full documentation.
}
\keyword{internal}
