% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_reserved_instances}
\alias{ec2_modify_reserved_instances}
\title{Modifies the configuration of your Reserved Instances, such as the
Availability Zone, instance count, or instance type}
\usage{
ec2_modify_reserved_instances(
  ReservedInstancesIds,
  ClientToken = NULL,
  TargetConfigurations
)
}
\arguments{
\item{ReservedInstancesIds}{[required] The IDs of the Reserved Instances to modify.}

\item{ClientToken}{A unique, case-sensitive token you provide to ensure idempotency of your
modification request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{TargetConfigurations}{[required] The configuration settings for the Reserved Instances to modify.}
}
\description{
Modifies the configuration of your Reserved Instances, such as the Availability Zone, instance count, or instance type. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_reserved_instances/} for full documentation.
}
\keyword{internal}
