% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_restore_managed_prefix_list_version}
\alias{ec2_restore_managed_prefix_list_version}
\title{Restores the entries from a previous version of a managed prefix list to
a new version of the prefix list}
\usage{
ec2_restore_managed_prefix_list_version(
  DryRun = NULL,
  PrefixListId,
  PreviousVersion,
  CurrentVersion
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PrefixListId}{[required] The ID of the prefix list.}

\item{PreviousVersion}{[required] The version to restore.}

\item{CurrentVersion}{[required] The current version number for the prefix list.}
}
\description{
Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.

See \url{https://www.paws-r-sdk.com/docs/ec2_restore_managed_prefix_list_version/} for full documentation.
}
\keyword{internal}
