% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_create_cluster}
\alias{eks_create_cluster}
\title{Creates an Amazon EKS control plane}
\usage{
eks_create_cluster(
  name,
  version = NULL,
  roleArn,
  resourcesVpcConfig,
  kubernetesNetworkConfig = NULL,
  logging = NULL,
  clientRequestToken = NULL,
  tags = NULL,
  encryptionConfig = NULL,
  outpostConfig = NULL,
  accessConfig = NULL
)
}
\arguments{
\item{name}{[required] The unique name to give to your cluster.}

\item{version}{The desired Kubernetes version for your cluster. If you don't specify a
value here, the default version available in Amazon EKS is used.

The default version might not be the latest version available.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that provides permissions
for the Kubernetes control plane to make calls to Amazon Web Services
API operations on your behalf. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html}{Amazon EKS Service IAM Role}
in the \emph{Amazon EKS User Guide} .}

\item{resourcesVpcConfig}{[required] The VPC configuration that's used by the cluster control plane. Amazon
EKS VPC resources have specific requirements to work properly with
Kubernetes. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html}{Cluster VPC Considerations}
and \href{https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html}{Cluster Security Group Considerations}
in the \emph{Amazon EKS User Guide}. You must specify at least two subnets.
You can specify up to five security groups. However, we recommend that
you use a dedicated security group for your cluster control plane.}

\item{kubernetesNetworkConfig}{The Kubernetes network configuration for the cluster.}

\item{logging}{Enable or disable exporting the Kubernetes control plane logs for your
cluster to CloudWatch Logs. By default, cluster control plane logs
aren't exported to CloudWatch Logs. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html}{Amazon EKS Cluster control plane logs}
in the \emph{Amazon EKS User Guide} .

CloudWatch Logs ingestion, archive storage, and data scanning rates
apply to exported control plane logs. For more information, see
\href{https://aws.amazon.com/cloudwatch/pricing/}{CloudWatch Pricing}.}

\item{clientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{tags}{Metadata that assists with categorization and organization. Each tag
consists of a key and an optional value. You define both. Tags don't
propagate to any other cluster or Amazon Web Services resources.}

\item{encryptionConfig}{The encryption configuration for the cluster.}

\item{outpostConfig}{An object representing the configuration of your local Amazon EKS
cluster on an Amazon Web Services Outpost. Before creating a local
cluster on an Outpost, review \href{https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html}{Local clusters for Amazon EKS on Amazon Web Services Outposts}
in the \emph{Amazon EKS User Guide}. This object isn't available for creating
Amazon EKS clusters on the Amazon Web Services cloud.}

\item{accessConfig}{The access configuration for the cluster.}
}
\description{
Creates an Amazon EKS control plane.

See \url{https://www.paws-r-sdk.com/docs/eks_create_cluster/} for full documentation.
}
\keyword{internal}
