% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_operations.R
\name{apprunner_list_services_for_auto_scaling_configuration}
\alias{apprunner_list_services_for_auto_scaling_configuration}
\title{Returns a list of the associated App Runner services using an auto
scaling configuration}
\usage{
apprunner_list_services_for_auto_scaling_configuration(
  AutoScalingConfigurationArn,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{AutoScalingConfigurationArn}{[required] The Amazon Resource Name (ARN) of the App Runner auto scaling
configuration that you want to list the services for.

The ARN can be a full auto scaling configuration ARN, or a partial ARN
ending with either \code{.../name } or \code{.../name/revision }. If a revision
isn't specified, the latest active revision is used.}

\item{MaxResults}{The maximum number of results to include in each response (result page).
It's used for a paginated request.

If you don't specify \code{MaxResults}, the request retrieves all available
results in a single response.}

\item{NextToken}{A token from a previous result page. It's used for a paginated request.
The request retrieves the next result page. All other parameter values
must be identical to the ones specified in the initial request.

If you don't specify \code{NextToken}, the request retrieves the first result
page.}
}
\description{
Returns a list of the associated App Runner services using an auto scaling configuration.

See \url{https://www.paws-r-sdk.com/docs/apprunner_list_services_for_auto_scaling_configuration/} for full documentation.
}
\keyword{internal}
