% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_route_table}
\alias{ec2_create_route_table}
\title{Creates a route table for the specified VPC}
\usage{
ec2_create_route_table(
  TagSpecifications = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  VpcId
)
}
\arguments{
\item{TagSpecifications}{The tags to assign to the route table.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcId}{[required] The ID of the VPC.}
}
\description{
Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_route_table/} for full documentation.
}
\keyword{internal}
