% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fleet_instances}
\alias{ec2_describe_fleet_instances}
\title{Describes the running instances for the specified EC2 Fleet}
\usage{
ec2_describe_fleet_instances(
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  FleetId,
  Filters = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{FleetId}{[required] The ID of the EC2 Fleet.}

\item{Filters}{The filters.
\itemize{
\item \code{instance-type} - The instance type.
}}
}
\description{
Describes the running instances for the specified EC2 Fleet.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_fleet_instances/} for full documentation.
}
\keyword{internal}
