% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_block_public_access_exclusions}
\alias{ec2_describe_vpc_block_public_access_exclusions}
\title{Describe VPC Block Public Access (BPA) exclusions}
\usage{
ec2_describe_vpc_block_public_access_exclusions(
  DryRun = NULL,
  Filters = NULL,
  ExclusionIds = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{Filters for the request:
\itemize{
\item \code{resource-arn} - The Amazon Resource Name (ARN) of a exclusion.
\item \code{internet-gateway-exclusion-mode} - The mode of a VPC BPA exclusion.
Possible values: \code{allow-bidirectional | allow-egress}.
\item \code{state} - The state of VPC BPA. Possible values:
\verb{create-in-progress | create-complete | update-in-progress | update-complete | delete-in-progress | deleted-complete | disable-in-progress | disable-complete}
\item \code{tag} - The key/value combination of a tag assigned to the resource.
Use the tag key in the filter name and the tag value as the filter
value. For example, to find all resources that have a tag with the
key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for the
filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{tag-value}: The value of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific value,
regardless of the tag key.
}}

\item{ExclusionIds}{IDs of exclusions.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describe VPC Block Public Access (BPA) exclusions. A VPC BPA exclusion is a mode that can be applied to a single VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html}{Block public access to VPCs and subnets} in the \emph{Amazon VPC User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_vpc_block_public_access_exclusions/} for full documentation.
}
\keyword{internal}
