% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_services}
\alias{ec2_describe_vpc_endpoint_services}
\title{Describes available services to which you can create a VPC endpoint}
\usage{
ec2_describe_vpc_endpoint_services(
  DryRun = NULL,
  ServiceNames = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  ServiceRegions = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceNames}{The service names.}

\item{Filters}{The filters.
\itemize{
\item \code{owner} - The ID or alias of the Amazon Web Services account that
owns the service.
\item \code{service-name} - The name of the service.
\item \code{service-region} - The Region of the service.
\item \code{service-type} - The type of service (\code{Interface} | \code{Gateway} |
\code{GatewayLoadBalancer}).
\item \code{supported-ip-address-types} - The IP address type (\code{ipv4} |
\code{ipv6}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{MaxResults}{The maximum number of items to return for this request. The request
returns a token that you can specify in a subsequent call to get the
next set of results.

Constraint: If the value is greater than 1,000, we return only 1,000
items.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a prior call.)}

\item{ServiceRegions}{The service Regions.}
}
\description{
Describes available services to which you can create a VPC endpoint.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_services/} for full documentation.
}
\keyword{internal}
