% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpc_block_public_access_options}
\alias{ec2_modify_vpc_block_public_access_options}
\title{Modify VPC Block Public Access (BPA) options}
\usage{
ec2_modify_vpc_block_public_access_options(
  DryRun = NULL,
  InternetGatewayBlockMode
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InternetGatewayBlockMode}{[required] The mode of VPC BPA.
\itemize{
\item \code{off}: VPC BPA is not enabled and traffic is allowed to and from
internet gateways and egress-only internet gateways in this Region.
\item \code{block-bidirectional}: Block all traffic to and from internet
gateways and egress-only internet gateways in this Region (except
for excluded VPCs and subnets).
\item \code{block-ingress}: Block all internet traffic to the VPCs in this
Region (except for VPCs or subnets which are excluded). Only traffic
to and from NAT gateways and egress-only internet gateways is
allowed because these gateways only allow outbound connections to be
established.
}}
}
\description{
Modify VPC Block Public Access (BPA) options. VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from reaching or being reached from the internet through internet gateways and egress-only internet gateways. To learn more about VPC BPA, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html}{Block public access to VPCs and subnets} in the \emph{Amazon VPC User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_vpc_block_public_access_options/} for full documentation.
}
\keyword{internal}
