% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_replace_route}
\alias{ec2_replace_route}
\title{Replaces an existing route within a route table in a VPC}
\usage{
ec2_replace_route(
  DestinationPrefixListId = NULL,
  VpcEndpointId = NULL,
  LocalTarget = NULL,
  TransitGatewayId = NULL,
  LocalGatewayId = NULL,
  CarrierGatewayId = NULL,
  CoreNetworkArn = NULL,
  DryRun = NULL,
  RouteTableId,
  DestinationCidrBlock = NULL,
  GatewayId = NULL,
  DestinationIpv6CidrBlock = NULL,
  EgressOnlyInternetGatewayId = NULL,
  InstanceId = NULL,
  NetworkInterfaceId = NULL,
  VpcPeeringConnectionId = NULL,
  NatGatewayId = NULL
)
}
\arguments{
\item{DestinationPrefixListId}{The ID of the prefix list for the route.}

\item{VpcEndpointId}{The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints
only.}

\item{LocalTarget}{Specifies whether to reset the local route to its default target
(\code{local}).}

\item{TransitGatewayId}{The ID of a transit gateway.}

\item{LocalGatewayId}{The ID of the local gateway.}

\item{CarrierGatewayId}{[IPv4 traffic only] The ID of a carrier gateway.}

\item{CoreNetworkArn}{The Amazon Resource Name (ARN) of the core network.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{RouteTableId}{[required] The ID of the route table.}

\item{DestinationCidrBlock}{The IPv4 CIDR address block used for the destination match. The value
that you provide must match the CIDR of an existing route in the table.}

\item{GatewayId}{The ID of an internet gateway or virtual private gateway.}

\item{DestinationIpv6CidrBlock}{The IPv6 CIDR address block used for the destination match. The value
that you provide must match the CIDR of an existing route in the table.}

\item{EgressOnlyInternetGatewayId}{[IPv6 traffic only] The ID of an egress-only internet gateway.}

\item{InstanceId}{The ID of a NAT instance in your VPC.}

\item{NetworkInterfaceId}{The ID of a network interface.}

\item{VpcPeeringConnectionId}{The ID of a VPC peering connection.}

\item{NatGatewayId}{[IPv4 traffic only] The ID of a NAT gateway.}
}
\description{
Replaces an existing route within a route table in a VPC.

See \url{https://www.paws-r-sdk.com/docs/ec2_replace_route/} for full documentation.
}
\keyword{internal}
