% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_update_repository_creation_template}
\alias{ecr_update_repository_creation_template}
\title{Updates an existing repository creation template}
\usage{
ecr_update_repository_creation_template(
  prefix,
  description = NULL,
  encryptionConfiguration = NULL,
  resourceTags = NULL,
  imageTagMutability = NULL,
  repositoryPolicy = NULL,
  lifecyclePolicy = NULL,
  appliedFor = NULL,
  customRoleArn = NULL
)
}
\arguments{
\item{prefix}{[required] The repository namespace prefix that matches an existing repository
creation template in the registry. All repositories created using this
namespace prefix will have the settings defined in this template
applied. For example, a prefix of \code{prod} would apply to all repositories
beginning with \verb{prod/}. This includes a repository named \code{prod/team1} as
well as a repository named \code{prod/repository1}.

To apply a template to all repositories in your registry that don't have
an associated creation template, you can use \code{ROOT} as the prefix.}

\item{description}{A description for the repository creation template.}

\item{encryptionConfiguration}{}

\item{resourceTags}{The metadata to apply to the repository to help you categorize and
organize. Each tag consists of a key and an optional value, both of
which you define. Tag keys can have a maximum character length of 128
characters, and tag values can have a maximum length of 256 characters.}

\item{imageTagMutability}{Updates the tag mutability setting for the repository. If this parameter
is omitted, the default setting of \code{MUTABLE} will be used which will
allow image tags to be overwritten. If \code{IMMUTABLE} is specified, all
image tags within the repository will be immutable which will prevent
them from being overwritten.}

\item{repositoryPolicy}{Updates the repository policy created using the template. A repository
policy is a permissions policy associated with a repository to control
access permissions.}

\item{lifecyclePolicy}{Updates the lifecycle policy associated with the specified repository
creation template.}

\item{appliedFor}{Updates the list of enumerable strings representing the Amazon ECR
repository creation scenarios that this template will apply towards. The
two supported scenarios are \code{PULL_THROUGH_CACHE} and \code{REPLICATION}}

\item{customRoleArn}{The ARN of the role to be assumed by Amazon ECR. This role must be in
the same account as the registry that you are configuring. Amazon ECR
will assume your supplied role when the customRoleArn is specified. When
this field isn't specified, Amazon ECR will use the service-linked role
for the repository creation template.}
}
\description{
Updates an existing repository creation template.

See \url{https://www.paws-r-sdk.com/docs/ecr_update_repository_creation_template/} for full documentation.
}
\keyword{internal}
