% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_reservation_utilization}
\alias{costexplorer_get_reservation_utilization}
\title{Retrieves the reservation utilization for your account}
\usage{
costexplorer_get_reservation_utilization(TimePeriod, GroupBy,
  Granularity, Filter, NextPageToken)
}
\arguments{
\item{TimePeriod}{[required] Sets the start and end dates for retrieving RI utilization. The start
date is inclusive, but the end date is exclusive. For example, if
\code{start} is \code{2017-01-01} and \code{end} is \code{2017-05-01}, then the cost and
usage data is retrieved from \code{2017-01-01} up to and including
\code{2017-04-30} but not including \code{2017-05-01}.}

\item{GroupBy}{Groups only by \code{SUBSCRIPTION_ID}. Metadata is included.}

\item{Granularity}{If \code{GroupBy} is set, \code{Granularity} can't be set. If \code{Granularity}
isn't set, the response object doesn't include \code{Granularity}, either
\code{MONTHLY} or \code{DAILY}. If both \code{GroupBy} and \code{Granularity} aren't set,
\code{GetReservationUtilization} defaults to \code{DAILY}.

The \code{GetReservationUtilization} operation supports only \code{DAILY} and
\code{MONTHLY} granularities.}

\item{Filter}{Filters utilization data by dimensions. You can filter by the following
dimensions:
\itemize{
\item AZ
\item CACHE\_ENGINE
\item DATABASE\_ENGINE
\item DEPLOYMENT\_OPTION
\item INSTANCE\_TYPE
\item LINKED\_ACCOUNT
\item OPERATING\_SYSTEM
\item PLATFORM
\item REGION
\item SERVICE
\item SCOPE
\item TENANCY
}

\code{GetReservationUtilization} uses the same
\href{http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html}{Expression}
object as the other operations, but only \code{AND} is supported among each
dimension, and nesting is supported up to only one level deep. If there
are multiple values for a dimension, they are OR'd together.}

\item{NextPageToken}{The token to retrieve the next set of results. AWS provides the token
when the response from a previous call has more results than the maximum
page size.}
}
\description{
Retrieves the reservation utilization for your account. Master accounts
in an organization have access to member accounts. You can filter data
by dimensions in a time period. You can use \code{GetDimensionValues} to
determine the possible dimension values. Currently, you can group only
by \code{SUBSCRIPTION_ID}.
}
\section{Request syntax}{
\preformatted{svc$get_reservation_utilization(
  TimePeriod = list(
    Start = "string",
    End = "string"
  ),
  GroupBy = list(
    list(
      Type = "DIMENSION"|"TAG",
      Key = "string"
    )
  ),
  Granularity = "DAILY"|"MONTHLY"|"HOURLY",
  Filter = list(
    Or = list(
      list()
    ),
    And = list(
      list()
    ),
    Not = list(),
    Dimensions = list(
      Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID",
      Values = list(
        "string"
      )
    ),
    Tags = list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextPageToken = "string"
)
}
}

\keyword{internal}
