# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWSMarketplace Metering
#'
#' @description
#' AWS Marketplace Metering Service
#' 
#' This reference provides descriptions of the low-level AWS Marketplace
#' Metering Service API.
#' 
#' AWS Marketplace sellers can use this API to submit usage data for custom
#' usage dimensions.
#' 
#' **Submitting Metering Records**
#' 
#' -   *MeterUsage*- Submits the metering record for a Marketplace product.
#'     MeterUsage is called from an EC2 instance.
#' 
#' -   *BatchMeterUsage*- Submits the metering record for a set of
#'     customers. BatchMeterUsage is called from a software-as-a-service
#'     (SaaS) application.
#' 
#' **Accepting New Customers**
#' 
#' -   *ResolveCustomer*- Called by a SaaS application during the
#'     registration process. When a buyer visits your website during the
#'     registration process, the buyer submits a Registration Token through
#'     the browser. The Registration Token is resolved through this API to
#'     obtain a CustomerIdentifier and Product Code.
#' 
#' **Entitlement and Metering for Paid Container Products**
#' 
#' -   Paid container software products sold through AWS Marketplace must
#'     integrate with the AWS Marketplace Metering Service and call the
#'     RegisterUsage operation for software entitlement and metering.
#'     Calling RegisterUsage from containers running outside of Amazon
#'     Elastic Container Service (Amazon ECR) isn\'t supported. Free and
#'     BYOL products for ECS aren\'t required to call RegisterUsage, but
#'     you can do so if you want to receive usage data in your seller
#'     reports. For more information on using the RegisterUsage operation,
#'     see [Container-Based
#'     Products](https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html).
#' 
#' BatchMeterUsage API calls are captured by AWS CloudTrail. You can use
#' Cloudtrail to verify that the SaaS metering records that you sent are
#' accurate by searching for records with the eventName of BatchMeterUsage.
#' You can also use CloudTrail to audit records over time. For more
#' information, see the *[AWS CloudTrail User
#' Guide](http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html)*
#' .
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- marketplacemetering(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- marketplacemetering()
#' svc$batch_meter_usage(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=marketplacemetering_batch_meter_usage]{batch_meter_usage} \tab BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers \cr
#'  \link[=marketplacemetering_meter_usage]{meter_usage} \tab API to emit metering records \cr
#'  \link[=marketplacemetering_register_usage]{register_usage} \tab Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the RegisterUsage operation for software entitlement and metering\cr
#'  \link[=marketplacemetering_resolve_customer]{resolve_customer} \tab ResolveCustomer is called by a SaaS application during the registration process 
#' }
#'
#' @rdname marketplacemetering
#' @export
marketplacemetering <- function(config = list()) {
  svc <- .marketplacemetering$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.marketplacemetering <- list()

.marketplacemetering$operations <- list()

.marketplacemetering$metadata <- list(
  service_name = "metering.marketplace",
  endpoints = list("*" = list(endpoint = "metering.marketplace.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "metering.marketplace.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Marketplace Metering",
  api_version = "2016-01-14",
  signing_name = "aws-marketplace",
  json_version = "1.1",
  target_prefix = "AWSMPMeteringService"
)

.marketplacemetering$handlers <- new_handlers("jsonrpc", "v4")

.marketplacemetering$service <- function(config = list()) {
  new_service(.marketplacemetering$metadata, .marketplacemetering$handlers, config)
}
