% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_tags}
\alias{costexplorer_get_tags}
\title{Queries for available tag keys and tag values for a specified period}
\usage{
costexplorer_get_tags(SearchString, TimePeriod, TagKey, NextPageToken)
}
\arguments{
\item{SearchString}{The value that you want to search for.}

\item{TimePeriod}{[required] The start and end dates for retrieving the dimension values. The start
date is inclusive, but the end date is exclusive. For example, if
\code{start} is \code{2017-01-01} and \code{end} is \code{2017-05-01}, then the cost and
usage data is retrieved from \code{2017-01-01} up to and including
\code{2017-04-30} but not including \code{2017-05-01}.}

\item{TagKey}{The key of the tag that you want to return values for.}

\item{NextPageToken}{The token to retrieve the next set of results. AWS provides the token
when the response from a previous call has more results than the maximum
page size.}
}
\description{
Queries for available tag keys and tag values for a specified period.
You can search the tag values for an arbitrary string.
}
\section{Request syntax}{
\preformatted{svc$get_tags(
  SearchString = "string",
  TimePeriod = list(
    Start = "string",
    End = "string"
  ),
  TagKey = "string",
  NextPageToken = "string"
)
}
}

\keyword{internal}
