% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_service.R
\name{paymentcryptographydataplane}
\alias{paymentcryptographydataplane}
\title{Payment Cryptography Data Plane}
\usage{
paymentcryptographydataplane(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
You use the Amazon Web Services Payment Cryptography Data Plane to
manage how encryption keys are used for payment-related transaction
processing and associated cryptographic operations. You can encrypt,
decrypt, generate, verify, and translate payment-related cryptographic
operations in Amazon Web Services Payment Cryptography. For more
information, see \href{https://docs.aws.amazon.com/payment-cryptography/latest/userguide/data-operations.html}{Data operations}
in the \emph{Amazon Web Services Payment Cryptography User Guide}.

To manage your encryption keys, you use the \href{https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/Welcome.html}{Amazon Web Services Payment Cryptography Control Plane}.
You can create, import, export, share, manage, and delete keys. You can
also manage Identity and Access Management (IAM) policies for keys.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- paymentcryptographydataplane(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=paymentcryptographydataplane_decrypt_data]{decrypt_data} \tab Decrypts ciphertext data to plaintext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme\cr
\link[=paymentcryptographydataplane_encrypt_data]{encrypt_data} \tab Encrypts plaintext data to ciphertext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme\cr
\link[=paymentcryptographydataplane_generate_card_validation_data]{generate_card_validation_data} \tab Generates card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security Codes (CSC)\cr
\link[=paymentcryptographydataplane_generate_mac]{generate_mac} \tab Generates a Message Authentication Code (MAC) cryptogram within Amazon Web Services Payment Cryptography\cr
\link[=paymentcryptographydataplane_generate_pin_data]{generate_pin_data} \tab Generates pin-related data such as PIN, PIN Verification Value (PVV), PIN Block, and PIN Offset during new card issuance or reissuance\cr
\link[=paymentcryptographydataplane_re_encrypt_data]{re_encrypt_data} \tab Re-encrypt ciphertext using DUKPT, Symmetric and Asymmetric Data Encryption Keys\cr
\link[=paymentcryptographydataplane_translate_pin_data]{translate_pin_data} \tab Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4\cr
\link[=paymentcryptographydataplane_verify_auth_request_cryptogram]{verify_auth_request_cryptogram} \tab Verifies Authorization Request Cryptogram (ARQC) for a EMV chip payment card authorization\cr
\link[=paymentcryptographydataplane_verify_card_validation_data]{verify_card_validation_data} \tab Verifies card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) and Card Security Codes (CSC)\cr
\link[=paymentcryptographydataplane_verify_mac]{verify_mac} \tab Verifies a Message Authentication Code (MAC)\cr
\link[=paymentcryptographydataplane_verify_pin_data]{verify_pin_data} \tab Verifies pin-related data such as PIN and PIN Offset using algorithms including VISA PVV and IBM3624
}
}

\examples{
\dontrun{
svc <- paymentcryptographydataplane()
svc$decrypt_data(
  Foo = 123
)
}

}
