# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Budgets
#'
#' @description
#' Use the Amazon Web Services Budgets API to plan your service usage,
#' service costs, and instance reservations. This API reference provides
#' descriptions, syntax, and usage examples for each of the actions and
#' data types for the Amazon Web Services Budgets feature.
#' 
#' Budgets provide you with a way to see the following information:
#' 
#' -   How close your plan is to your budgeted amount or to the free tier
#'     limits
#' 
#' -   Your usage-to-date, including how much you've used of your Reserved
#'     Instances (RIs)
#' 
#' -   Your current estimated charges from Amazon Web Services, and how
#'     much your predicted usage will accrue in charges by the end of the
#'     month
#' 
#' -   How much of your budget has been used
#' 
#' Amazon Web Services updates your budget status several times a day.
#' Budgets track your unblended costs, subscriptions, refunds, and RIs. You
#' can create the following types of budgets:
#' 
#' -   **Cost budgets** - Plan how much you want to spend on a service.
#' 
#' -   **Usage budgets** - Plan how much you want to use one or more
#'     services.
#' 
#' -   **RI utilization budgets** - Define a utilization threshold, and
#'     receive alerts when your RI usage falls below that threshold. This
#'     lets you see if your RIs are unused or under-utilized.
#' 
#' -   **RI coverage budgets** - Define a coverage threshold, and receive
#'     alerts when the number of your instance hours that are covered by
#'     RIs fall below that threshold. This lets you see how much of your
#'     instance usage is covered by a reservation.
#' 
#' Service Endpoint
#' 
#' The Amazon Web Services Budgets API provides the following endpoint:
#' 
#' -   https://budgets.amazonaws.com
#' 
#' For information about costs that are associated with the Amazon Web
#' Services Budgets API, see [Amazon Web Services Cost Management
#' Pricing](https://aws.amazon.com/aws-cost-management/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- budgets(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- budgets()
#' svc$create_budget(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=budgets_create_budget]{create_budget} \tab Creates a budget and, if included, notifications and subscribers\cr
#'  \link[=budgets_create_budget_action]{create_budget_action} \tab Creates a budget action\cr
#'  \link[=budgets_create_notification]{create_notification} \tab Creates a notification\cr
#'  \link[=budgets_create_subscriber]{create_subscriber} \tab Creates a subscriber\cr
#'  \link[=budgets_delete_budget]{delete_budget} \tab Deletes a budget\cr
#'  \link[=budgets_delete_budget_action]{delete_budget_action} \tab Deletes a budget action\cr
#'  \link[=budgets_delete_notification]{delete_notification} \tab Deletes a notification\cr
#'  \link[=budgets_delete_subscriber]{delete_subscriber} \tab Deletes a subscriber\cr
#'  \link[=budgets_describe_budget]{describe_budget} \tab Describes a budget\cr
#'  \link[=budgets_describe_budget_action]{describe_budget_action} \tab Describes a budget action detail\cr
#'  \link[=budgets_describe_budget_action_histories]{describe_budget_action_histories} \tab Describes a budget action history detail\cr
#'  \link[=budgets_describe_budget_actions_for_account]{describe_budget_actions_for_account} \tab Describes all of the budget actions for an account\cr
#'  \link[=budgets_describe_budget_actions_for_budget]{describe_budget_actions_for_budget} \tab Describes all of the budget actions for a budget\cr
#'  \link[=budgets_describe_budget_notifications_for_account]{describe_budget_notifications_for_account} \tab Lists the budget names and notifications that are associated with an account\cr
#'  \link[=budgets_describe_budget_performance_history]{describe_budget_performance_history} \tab Describes the history for DAILY, MONTHLY, and QUARTERLY budgets\cr
#'  \link[=budgets_describe_budgets]{describe_budgets} \tab Lists the budgets that are associated with an account\cr
#'  \link[=budgets_describe_notifications_for_budget]{describe_notifications_for_budget} \tab Lists the notifications that are associated with a budget\cr
#'  \link[=budgets_describe_subscribers_for_notification]{describe_subscribers_for_notification} \tab Lists the subscribers that are associated with a notification\cr
#'  \link[=budgets_execute_budget_action]{execute_budget_action} \tab Executes a budget action\cr
#'  \link[=budgets_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags associated with a budget or budget action resource\cr
#'  \link[=budgets_tag_resource]{tag_resource} \tab Creates tags for a budget or budget action resource\cr
#'  \link[=budgets_untag_resource]{untag_resource} \tab Deletes tags associated with a budget or budget action resource\cr
#'  \link[=budgets_update_budget]{update_budget} \tab Updates a budget\cr
#'  \link[=budgets_update_budget_action]{update_budget_action} \tab Updates a budget action\cr
#'  \link[=budgets_update_notification]{update_notification} \tab Updates a notification\cr
#'  \link[=budgets_update_subscriber]{update_subscriber} \tab Updates a subscriber
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname budgets
#' @export
budgets <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .budgets$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.budgets <- list()

.budgets$operations <- list()

.budgets$metadata <- list(
  service_name = "budgets",
  endpoints = list("aws-global" = list(endpoint = "budgets.amazonaws.com", global = TRUE), "us-east-1" = list(endpoint = "budgets.amazonaws.com", global = TRUE), "^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "budgets.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Budgets",
  api_version = "2016-10-20",
  signing_name = "budgets",
  json_version = "1.1",
  target_prefix = "AWSBudgetServiceGateway"
)

.budgets$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.budgets$metadata, handlers, config, op)
}
