% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_list_templates}
\alias{pinpoint_list_templates}
\title{Retrieves information about all the message templates that are
associated with your Amazon Pinpoint account}
\usage{
pinpoint_list_templates(NextToken, PageSize, Prefix, TemplateType)
}
\arguments{
\item{NextToken}{The string that specifies which page of results to return in a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{Prefix}{The substring to match in the names of the message templates to include
in the results. If you specify this value, Amazon Pinpoint returns only
those templates whose names begin with the value that you specify.}

\item{TemplateType}{The type of message template to include in the results. Valid values
are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in
the results, don't include this parameter in your request.}
}
\description{
Retrieves information about all the message templates that are
associated with your Amazon Pinpoint account.
}
\section{Request syntax}{
\preformatted{svc$list_templates(
  NextToken = "string",
  PageSize = "string",
  Prefix = "string",
  TemplateType = "string"
)
}
}

\keyword{internal}
