% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_contact_streaming}
\alias{connect_start_contact_streaming}
\title{Initiates real-time message streaming for a new chat contact}
\usage{
connect_start_contact_streaming(
  InstanceId,
  ContactId,
  ChatStreamingConfiguration,
  ClientToken
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{ContactId}{[required] The identifier of the contact. This is the identifier of the contact
associated with the first interaction with the contact center.}

\item{ChatStreamingConfiguration}{[required] The streaming configuration, such as the Amazon SNS streaming endpoint.}

\item{ClientToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Initiates real-time message streaming for a new chat contact.

See \url{https://www.paws-r-sdk.com/docs/connect_start_contact_streaming/} for full documentation.
}
\keyword{internal}
