% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_create_integration_workflow}
\alias{customerprofiles_create_integration_workflow}
\title{Creates an integration workflow}
\usage{
customerprofiles_create_integration_workflow(
  DomainName,
  WorkflowType,
  IntegrationConfig,
  ObjectTypeName,
  RoleArn,
  Tags = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{WorkflowType}{[required] The type of workflow. The only supported value is APPFLOW_INTEGRATION.}

\item{IntegrationConfig}{[required] Configuration data for integration workflow.}

\item{ObjectTypeName}{[required] The name of the profile object type.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role. Customer Profiles
assumes this role to create resources on your behalf as part of workflow
execution.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_create_integration_workflow/} for full documentation.
}
\keyword{internal}
