% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_identity_headers_in_notifications_enabled}
\alias{ses_set_identity_headers_in_notifications_enabled}
\title{Given an identity (an email address or a domain), sets whether Amazon
SES includes the original email headers in the Amazon Simple
Notification Service (Amazon SNS) notifications of a specified type}
\usage{
ses_set_identity_headers_in_notifications_enabled(
  Identity,
  NotificationType,
  Enabled
)
}
\arguments{
\item{Identity}{[required] The identity for which to enable or disable headers in notifications.
Examples: \code{user@example.com}, \code{example.com}.}

\item{NotificationType}{[required] The notification type for which to enable or disable headers in
notifications.}

\item{Enabled}{[required] Sets whether Amazon SES includes the original email headers in Amazon
SNS notifications of the specified notification type. A value of \code{true}
specifies that Amazon SES includes headers in notifications, and a value
of \code{false} specifies that Amazon SES does not include headers in
notifications.

This value can only be set when \code{NotificationType} is already set to use
a particular Amazon SNS topic.}
}
\description{
Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.

See \url{https://www.paws-r-sdk.com/docs/ses_set_identity_headers_in_notifications_enabled/} for full documentation.
}
\keyword{internal}
