% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_request_phone_number}
\alias{pinpointsmsvoicev2_request_phone_number}
\title{Request an origination phone number for use in your account}
\usage{
pinpointsmsvoicev2_request_phone_number(
  IsoCountryCode,
  MessageType,
  NumberCapabilities,
  NumberType,
  OptOutListName = NULL,
  PoolId = NULL,
  RegistrationId = NULL,
  DeletionProtectionEnabled = NULL,
  Tags = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{IsoCountryCode}{[required] The two-character code, in ISO 3166-1 alpha-2 format, for the country or
region.}

\item{MessageType}{[required] The type of message. Valid values are TRANSACTIONAL for messages that
are critical or time-sensitive and PROMOTIONAL for messages that aren't
critical or time-sensitive.}

\item{NumberCapabilities}{[required] Indicates if the phone number will be used for text messages, voice
messages, or both.}

\item{NumberType}{[required] The type of phone number to request.}

\item{OptOutListName}{The name of the OptOutList to associate with the phone number. You can
use the OptOutListName or OptOutListArn.}

\item{PoolId}{The pool to associated with the phone number. You can use the PoolId or
PoolArn.}

\item{RegistrationId}{Use this field to attach your phone number for an external registration
process.}

\item{DeletionProtectionEnabled}{By default this is set to false. When set to true the phone number can't
be deleted.}

\item{Tags}{An array of tags (key and value pairs) associate with the requested
phone number.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don't specify a client token, a
randomly generated token is used for the request to ensure idempotency.}
}
\description{
Request an origination phone number for use in your account. For more information on phone number request see \href{https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-request.html}{Requesting a number} in the \emph{Amazon Pinpoint User Guide}.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_request_phone_number/} for full documentation.
}
\keyword{internal}
