# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include customerprofiles_service.R
NULL

#' Associates a new key value with a specific profile, such as a Contact
#' Record ContactId
#'
#' @description
#' Associates a new key value with a specific profile, such as a Contact Record ContactId.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_add_profile_key/](https://www.paws-r-sdk.com/docs/customerprofiles_add_profile_key/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param KeyName &#91;required&#93; A searchable identifier of a customer profile. The predefined keys you
#' can use include: _account, _profileId, _assetId, _caseId, _orderId,
#' _fullName, _phone, _email, _ctrContactId, _marketoLeadId,
#' _salesforceAccountId, _salesforceContactId, _salesforceAssetId,
#' _zendeskUserId, _zendeskExternalId, _zendeskTicketId,
#' _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId,
#' _shopifyCustomerId, _shopifyOrderId.
#' @param Values &#91;required&#93; A list of key values.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_add_profile_key
customerprofiles_add_profile_key <- function(ProfileId, KeyName, Values, DomainName) {
  op <- new_operation(
    name = "AddProfileKey",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/keys",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$add_profile_key_input(ProfileId = ProfileId, KeyName = KeyName, Values = Values, DomainName = DomainName)
  output <- .customerprofiles$add_profile_key_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$add_profile_key <- customerprofiles_add_profile_key

#' Creates a new calculated attribute definition
#'
#' @description
#' Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles will be included in the calculated attribute, which can be retrieved for a profile using the [`get_calculated_attribute_for_profile`][customerprofiles_get_calculated_attribute_for_profile] API. Defining a calculated attribute makes it available for all profiles within a domain. Each calculated attribute can only reference one `ObjectType` and at most, two fields from that `ObjectType`.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_create_calculated_attribute_definition/](https://www.paws-r-sdk.com/docs/customerprofiles_create_calculated_attribute_definition/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param CalculatedAttributeName &#91;required&#93; The unique name of the calculated attribute.
#' @param DisplayName The display name of the calculated attribute.
#' @param Description The description of the calculated attribute.
#' @param AttributeDetails &#91;required&#93; Mathematical expression and a list of attribute items specified in that
#' expression.
#' @param Conditions The conditions including range, object count, and threshold for the
#' calculated attribute.
#' @param Statistic &#91;required&#93; The aggregation operation to perform for the calculated attribute.
#' @param Tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_create_calculated_attribute_definition
customerprofiles_create_calculated_attribute_definition <- function(DomainName, CalculatedAttributeName, DisplayName = NULL, Description = NULL, AttributeDetails, Conditions = NULL, Statistic, Tags = NULL) {
  op <- new_operation(
    name = "CreateCalculatedAttributeDefinition",
    http_method = "POST",
    http_path = "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$create_calculated_attribute_definition_input(DomainName = DomainName, CalculatedAttributeName = CalculatedAttributeName, DisplayName = DisplayName, Description = Description, AttributeDetails = AttributeDetails, Conditions = Conditions, Statistic = Statistic, Tags = Tags)
  output <- .customerprofiles$create_calculated_attribute_definition_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$create_calculated_attribute_definition <- customerprofiles_create_calculated_attribute_definition

#' Creates a domain, which is a container for all customer data, such as
#' customer profile attributes, object types, profile keys, and encryption
#' keys
#'
#' @description
#' Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_create_domain/](https://www.paws-r-sdk.com/docs/customerprofiles_create_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param DefaultExpirationDays &#91;required&#93; The default number of days until the data within the domain expires.
#' @param DefaultEncryptionKey The default encryption key, which is an AWS managed key, is used when no
#' specific type of encryption key is specified. It is used to encrypt all
#' data before it is placed in permanent or semi-permanent storage.
#' @param DeadLetterQueueUrl The URL of the SQS dead letter queue, which is used for reporting errors
#' associated with ingesting data from third party applications. You must
#' set up a policy on the DeadLetterQueue for the SendMessage operation to
#' enable Amazon Connect Customer Profiles to send messages to the
#' DeadLetterQueue.
#' @param Matching The process of matching duplicate profiles. If `Matching` = `true`,
#' Amazon Connect Customer Profiles starts a weekly batch process called
#' Identity Resolution Job. If you do not specify a date and time for
#' Identity Resolution Job to run, by default it runs every Saturday at
#' 12AM UTC to detect duplicate profiles in your domains.
#' 
#' After the Identity Resolution Job completes, use the
#' [`get_matches`][customerprofiles_get_matches] API to return and review
#' the results. Or, if you have configured `ExportingConfig` in the
#' `MatchingRequest`, you can download the results from S3.
#' @param RuleBasedMatching The process of matching duplicate profiles using the Rule-Based
#' matching. If `RuleBasedMatching` = true, Amazon Connect Customer
#' Profiles will start to match and merge your profiles according to your
#' configuration in the `RuleBasedMatchingRequest`. You can use the
#' [`list_rule_based_matches`][customerprofiles_list_rule_based_matches]
#' and [`get_similar_profiles`][customerprofiles_get_similar_profiles] API
#' to return and review the results. Also, if you have configured
#' `ExportingConfig` in the `RuleBasedMatchingRequest`, you can download
#' the results from S3.
#' @param Tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_create_domain
customerprofiles_create_domain <- function(DomainName, DefaultExpirationDays, DefaultEncryptionKey = NULL, DeadLetterQueueUrl = NULL, Matching = NULL, RuleBasedMatching = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/domains/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$create_domain_input(DomainName = DomainName, DefaultExpirationDays = DefaultExpirationDays, DefaultEncryptionKey = DefaultEncryptionKey, DeadLetterQueueUrl = DeadLetterQueueUrl, Matching = Matching, RuleBasedMatching = RuleBasedMatching, Tags = Tags)
  output <- .customerprofiles$create_domain_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$create_domain <- customerprofiles_create_domain

#' Creates an event stream, which is a subscription to real-time events,
#' such as when profiles are created and updated through Amazon Connect
#' Customer Profiles
#'
#' @description
#' Creates an event stream, which is a subscription to real-time events, such as when profiles are created and updated through Amazon Connect Customer Profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_create_event_stream/](https://www.paws-r-sdk.com/docs/customerprofiles_create_event_stream/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param Uri &#91;required&#93; The StreamARN of the destination to deliver profile events to. For
#' example, arn:aws:kinesis:region:account-id:stream/stream-name
#' @param EventStreamName &#91;required&#93; The name of the event stream.
#' @param Tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_create_event_stream
customerprofiles_create_event_stream <- function(DomainName, Uri, EventStreamName, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventStream",
    http_method = "POST",
    http_path = "/domains/{DomainName}/event-streams/{EventStreamName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$create_event_stream_input(DomainName = DomainName, Uri = Uri, EventStreamName = EventStreamName, Tags = Tags)
  output <- .customerprofiles$create_event_stream_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$create_event_stream <- customerprofiles_create_event_stream

#' Creates an integration workflow
#'
#' @description
#' Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_create_integration_workflow/](https://www.paws-r-sdk.com/docs/customerprofiles_create_integration_workflow/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param WorkflowType &#91;required&#93; The type of workflow. The only supported value is APPFLOW_INTEGRATION.
#' @param IntegrationConfig &#91;required&#93; Configuration data for integration workflow.
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role. Customer Profiles
#' assumes this role to create resources on your behalf as part of workflow
#' execution.
#' @param Tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_create_integration_workflow
customerprofiles_create_integration_workflow <- function(DomainName, WorkflowType, IntegrationConfig, ObjectTypeName, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateIntegrationWorkflow",
    http_method = "POST",
    http_path = "/domains/{DomainName}/workflows/integrations",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$create_integration_workflow_input(DomainName = DomainName, WorkflowType = WorkflowType, IntegrationConfig = IntegrationConfig, ObjectTypeName = ObjectTypeName, RoleArn = RoleArn, Tags = Tags)
  output <- .customerprofiles$create_integration_workflow_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$create_integration_workflow <- customerprofiles_create_integration_workflow

#' Creates a standard profile
#'
#' @description
#' Creates a standard profile.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_create_profile/](https://www.paws-r-sdk.com/docs/customerprofiles_create_profile/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param AccountNumber An account number that you have given to the customer.
#' @param AdditionalInformation Any additional information relevant to the customer’s profile.
#' @param PartyType The type of profile used to describe the customer.
#' @param BusinessName The name of the customer’s business.
#' @param FirstName The customer’s first name.
#' @param MiddleName The customer’s middle name.
#' @param LastName The customer’s last name.
#' @param BirthDate The customer’s birth date.
#' @param Gender The gender with which the customer identifies.
#' @param PhoneNumber The customer’s phone number, which has not been specified as a mobile,
#' home, or business number.
#' @param MobilePhoneNumber The customer’s mobile phone number.
#' @param HomePhoneNumber The customer’s home phone number.
#' @param BusinessPhoneNumber The customer’s business phone number.
#' @param EmailAddress The customer’s email address, which has not been specified as a personal
#' or business address.
#' @param PersonalEmailAddress The customer’s personal email address.
#' @param BusinessEmailAddress The customer’s business email address.
#' @param Address A generic address associated with the customer that is not mailing,
#' shipping, or billing.
#' @param ShippingAddress The customer’s shipping address.
#' @param MailingAddress The customer’s mailing address.
#' @param BillingAddress The customer’s billing address.
#' @param Attributes A key value pair of attributes of a customer profile.
#' @param PartyTypeString An alternative to `PartyType` which accepts any string as input.
#' @param GenderString An alternative to `Gender` which accepts any string as input.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_create_profile
customerprofiles_create_profile <- function(DomainName, AccountNumber = NULL, AdditionalInformation = NULL, PartyType = NULL, BusinessName = NULL, FirstName = NULL, MiddleName = NULL, LastName = NULL, BirthDate = NULL, Gender = NULL, PhoneNumber = NULL, MobilePhoneNumber = NULL, HomePhoneNumber = NULL, BusinessPhoneNumber = NULL, EmailAddress = NULL, PersonalEmailAddress = NULL, BusinessEmailAddress = NULL, Address = NULL, ShippingAddress = NULL, MailingAddress = NULL, BillingAddress = NULL, Attributes = NULL, PartyTypeString = NULL, GenderString = NULL) {
  op <- new_operation(
    name = "CreateProfile",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$create_profile_input(DomainName = DomainName, AccountNumber = AccountNumber, AdditionalInformation = AdditionalInformation, PartyType = PartyType, BusinessName = BusinessName, FirstName = FirstName, MiddleName = MiddleName, LastName = LastName, BirthDate = BirthDate, Gender = Gender, PhoneNumber = PhoneNumber, MobilePhoneNumber = MobilePhoneNumber, HomePhoneNumber = HomePhoneNumber, BusinessPhoneNumber = BusinessPhoneNumber, EmailAddress = EmailAddress, PersonalEmailAddress = PersonalEmailAddress, BusinessEmailAddress = BusinessEmailAddress, Address = Address, ShippingAddress = ShippingAddress, MailingAddress = MailingAddress, BillingAddress = BillingAddress, Attributes = Attributes, PartyTypeString = PartyTypeString, GenderString = GenderString)
  output <- .customerprofiles$create_profile_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$create_profile <- customerprofiles_create_profile

#' Deletes an existing calculated attribute definition
#'
#' @description
#' Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own using the CreateCalculatedAttributeDefinition API if you want it back.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_calculated_attribute_definition/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_calculated_attribute_definition/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param CalculatedAttributeName &#91;required&#93; The unique name of the calculated attribute.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_calculated_attribute_definition
customerprofiles_delete_calculated_attribute_definition <- function(DomainName, CalculatedAttributeName) {
  op <- new_operation(
    name = "DeleteCalculatedAttributeDefinition",
    http_method = "DELETE",
    http_path = "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_calculated_attribute_definition_input(DomainName = DomainName, CalculatedAttributeName = CalculatedAttributeName)
  output <- .customerprofiles$delete_calculated_attribute_definition_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_calculated_attribute_definition <- customerprofiles_delete_calculated_attribute_definition

#' Deletes a specific domain and all of its customer data, such as customer
#' profile attributes and their related objects
#'
#' @description
#' Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_domain/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_domain
customerprofiles_delete_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "DELETE",
    http_path = "/domains/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_domain_input(DomainName = DomainName)
  output <- .customerprofiles$delete_domain_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_domain <- customerprofiles_delete_domain

#' Disables and deletes the specified event stream
#'
#' @description
#' Disables and deletes the specified event stream.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_event_stream/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_event_stream/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param EventStreamName &#91;required&#93; The name of the event stream
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_event_stream
customerprofiles_delete_event_stream <- function(DomainName, EventStreamName) {
  op <- new_operation(
    name = "DeleteEventStream",
    http_method = "DELETE",
    http_path = "/domains/{DomainName}/event-streams/{EventStreamName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_event_stream_input(DomainName = DomainName, EventStreamName = EventStreamName)
  output <- .customerprofiles$delete_event_stream_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_event_stream <- customerprofiles_delete_event_stream

#' Removes an integration from a specific domain
#'
#' @description
#' Removes an integration from a specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_integration/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_integration/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param Uri &#91;required&#93; The URI of the S3 bucket or any other type of data source.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_integration
customerprofiles_delete_integration <- function(DomainName, Uri) {
  op <- new_operation(
    name = "DeleteIntegration",
    http_method = "POST",
    http_path = "/domains/{DomainName}/integrations/delete",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_integration_input(DomainName = DomainName, Uri = Uri)
  output <- .customerprofiles$delete_integration_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_integration <- customerprofiles_delete_integration

#' Deletes the standard customer profile and all data pertaining to the
#' profile
#'
#' @description
#' Deletes the standard customer profile and all data pertaining to the profile.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_profile
customerprofiles_delete_profile <- function(ProfileId, DomainName) {
  op <- new_operation(
    name = "DeleteProfile",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/delete",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_profile_input(ProfileId = ProfileId, DomainName = DomainName)
  output <- .customerprofiles$delete_profile_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_profile <- customerprofiles_delete_profile

#' Removes a searchable key from a customer profile
#'
#' @description
#' Removes a searchable key from a customer profile.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile_key/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile_key/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param KeyName &#91;required&#93; A searchable identifier of a customer profile.
#' @param Values &#91;required&#93; A list of key values.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_profile_key
customerprofiles_delete_profile_key <- function(ProfileId, KeyName, Values, DomainName) {
  op <- new_operation(
    name = "DeleteProfileKey",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/keys/delete",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_profile_key_input(ProfileId = ProfileId, KeyName = KeyName, Values = Values, DomainName = DomainName)
  output <- .customerprofiles$delete_profile_key_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_profile_key <- customerprofiles_delete_profile_key

#' Removes an object associated with a profile of a given ProfileObjectType
#'
#' @description
#' Removes an object associated with a profile of a given ProfileObjectType.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile_object/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile_object/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param ProfileObjectUniqueKey &#91;required&#93; The unique identifier of the profile object generated by the service.
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_profile_object
customerprofiles_delete_profile_object <- function(ProfileId, ProfileObjectUniqueKey, ObjectTypeName, DomainName) {
  op <- new_operation(
    name = "DeleteProfileObject",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/objects/delete",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_profile_object_input(ProfileId = ProfileId, ProfileObjectUniqueKey = ProfileObjectUniqueKey, ObjectTypeName = ObjectTypeName, DomainName = DomainName)
  output <- .customerprofiles$delete_profile_object_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_profile_object <- customerprofiles_delete_profile_object

#' Removes a ProfileObjectType from a specific domain as well as removes
#' all the ProfileObjects of that type
#'
#' @description
#' Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile_object_type/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_profile_object_type/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_profile_object_type
customerprofiles_delete_profile_object_type <- function(DomainName, ObjectTypeName) {
  op <- new_operation(
    name = "DeleteProfileObjectType",
    http_method = "DELETE",
    http_path = "/domains/{DomainName}/object-types/{ObjectTypeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_profile_object_type_input(DomainName = DomainName, ObjectTypeName = ObjectTypeName)
  output <- .customerprofiles$delete_profile_object_type_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_profile_object_type <- customerprofiles_delete_profile_object_type

#' Deletes the specified workflow and all its corresponding resources
#'
#' @description
#' Deletes the specified workflow and all its corresponding resources. This is an async process.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_delete_workflow/](https://www.paws-r-sdk.com/docs/customerprofiles_delete_workflow/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param WorkflowId &#91;required&#93; Unique identifier for the workflow.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_delete_workflow
customerprofiles_delete_workflow <- function(DomainName, WorkflowId) {
  op <- new_operation(
    name = "DeleteWorkflow",
    http_method = "DELETE",
    http_path = "/domains/{DomainName}/workflows/{WorkflowId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$delete_workflow_input(DomainName = DomainName, WorkflowId = WorkflowId)
  output <- .customerprofiles$delete_workflow_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$delete_workflow <- customerprofiles_delete_workflow

#' The process of detecting profile object type mapping by using given
#' objects
#'
#' @description
#' The process of detecting profile object type mapping by using given objects.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_detect_profile_object_type/](https://www.paws-r-sdk.com/docs/customerprofiles_detect_profile_object_type/) for full documentation.
#'
#' @param Objects &#91;required&#93; A string that is serialized from a JSON object.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_detect_profile_object_type
customerprofiles_detect_profile_object_type <- function(Objects, DomainName) {
  op <- new_operation(
    name = "DetectProfileObjectType",
    http_method = "POST",
    http_path = "/domains/{DomainName}/detect/object-types",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$detect_profile_object_type_input(Objects = Objects, DomainName = DomainName)
  output <- .customerprofiles$detect_profile_object_type_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$detect_profile_object_type <- customerprofiles_detect_profile_object_type

#' Tests the auto-merging settings of your Identity Resolution Job without
#' merging your data
#'
#' @description
#' Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_auto_merging_preview/](https://www.paws-r-sdk.com/docs/customerprofiles_get_auto_merging_preview/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param Consolidation &#91;required&#93; A list of matching attributes that represent matching criteria.
#' @param ConflictResolution &#91;required&#93; How the auto-merging process should resolve conflicts between different
#' profiles.
#' @param MinAllowedConfidenceScoreForMerging Minimum confidence score required for profiles within a matching group
#' to be merged during the auto-merge process.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_auto_merging_preview
customerprofiles_get_auto_merging_preview <- function(DomainName, Consolidation, ConflictResolution, MinAllowedConfidenceScoreForMerging = NULL) {
  op <- new_operation(
    name = "GetAutoMergingPreview",
    http_method = "POST",
    http_path = "/domains/{DomainName}/identity-resolution-jobs/auto-merging-preview",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_auto_merging_preview_input(DomainName = DomainName, Consolidation = Consolidation, ConflictResolution = ConflictResolution, MinAllowedConfidenceScoreForMerging = MinAllowedConfidenceScoreForMerging)
  output <- .customerprofiles$get_auto_merging_preview_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_auto_merging_preview <- customerprofiles_get_auto_merging_preview

#' Provides more information on a calculated attribute definition for
#' Customer Profiles
#'
#' @description
#' Provides more information on a calculated attribute definition for Customer Profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_calculated_attribute_definition/](https://www.paws-r-sdk.com/docs/customerprofiles_get_calculated_attribute_definition/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param CalculatedAttributeName &#91;required&#93; The unique name of the calculated attribute.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_calculated_attribute_definition
customerprofiles_get_calculated_attribute_definition <- function(DomainName, CalculatedAttributeName) {
  op <- new_operation(
    name = "GetCalculatedAttributeDefinition",
    http_method = "GET",
    http_path = "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_calculated_attribute_definition_input(DomainName = DomainName, CalculatedAttributeName = CalculatedAttributeName)
  output <- .customerprofiles$get_calculated_attribute_definition_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_calculated_attribute_definition <- customerprofiles_get_calculated_attribute_definition

#' Retrieve a calculated attribute for a customer profile
#'
#' @description
#' Retrieve a calculated attribute for a customer profile.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_calculated_attribute_for_profile/](https://www.paws-r-sdk.com/docs/customerprofiles_get_calculated_attribute_for_profile/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param CalculatedAttributeName &#91;required&#93; The unique name of the calculated attribute.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_calculated_attribute_for_profile
customerprofiles_get_calculated_attribute_for_profile <- function(DomainName, ProfileId, CalculatedAttributeName) {
  op <- new_operation(
    name = "GetCalculatedAttributeForProfile",
    http_method = "GET",
    http_path = "/domains/{DomainName}/profile/{ProfileId}/calculated-attributes/{CalculatedAttributeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_calculated_attribute_for_profile_input(DomainName = DomainName, ProfileId = ProfileId, CalculatedAttributeName = CalculatedAttributeName)
  output <- .customerprofiles$get_calculated_attribute_for_profile_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_calculated_attribute_for_profile <- customerprofiles_get_calculated_attribute_for_profile

#' Returns information about a specific domain
#'
#' @description
#' Returns information about a specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_domain/](https://www.paws-r-sdk.com/docs/customerprofiles_get_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_domain
customerprofiles_get_domain <- function(DomainName) {
  op <- new_operation(
    name = "GetDomain",
    http_method = "GET",
    http_path = "/domains/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_domain_input(DomainName = DomainName)
  output <- .customerprofiles$get_domain_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_domain <- customerprofiles_get_domain

#' Returns information about the specified event stream in a specific
#' domain
#'
#' @description
#' Returns information about the specified event stream in a specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_event_stream/](https://www.paws-r-sdk.com/docs/customerprofiles_get_event_stream/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param EventStreamName &#91;required&#93; The name of the event stream provided during create operations.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_event_stream
customerprofiles_get_event_stream <- function(DomainName, EventStreamName) {
  op <- new_operation(
    name = "GetEventStream",
    http_method = "GET",
    http_path = "/domains/{DomainName}/event-streams/{EventStreamName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_event_stream_input(DomainName = DomainName, EventStreamName = EventStreamName)
  output <- .customerprofiles$get_event_stream_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_event_stream <- customerprofiles_get_event_stream

#' Returns information about an Identity Resolution Job in a specific
#' domain
#'
#' @description
#' Returns information about an Identity Resolution Job in a specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_identity_resolution_job/](https://www.paws-r-sdk.com/docs/customerprofiles_get_identity_resolution_job/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param JobId &#91;required&#93; The unique identifier of the Identity Resolution Job.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_identity_resolution_job
customerprofiles_get_identity_resolution_job <- function(DomainName, JobId) {
  op <- new_operation(
    name = "GetIdentityResolutionJob",
    http_method = "GET",
    http_path = "/domains/{DomainName}/identity-resolution-jobs/{JobId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_identity_resolution_job_input(DomainName = DomainName, JobId = JobId)
  output <- .customerprofiles$get_identity_resolution_job_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_identity_resolution_job <- customerprofiles_get_identity_resolution_job

#' Returns an integration for a domain
#'
#' @description
#' Returns an integration for a domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_integration/](https://www.paws-r-sdk.com/docs/customerprofiles_get_integration/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param Uri &#91;required&#93; The URI of the S3 bucket or any other type of data source.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_integration
customerprofiles_get_integration <- function(DomainName, Uri) {
  op <- new_operation(
    name = "GetIntegration",
    http_method = "POST",
    http_path = "/domains/{DomainName}/integrations",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_integration_input(DomainName = DomainName, Uri = Uri)
  output <- .customerprofiles$get_integration_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_integration <- customerprofiles_get_integration

#' Before calling this API, use CreateDomain or UpdateDomain to enable
#' identity resolution: set Matching to true
#'
#' @description
#' Before calling this API, use [`create_domain`][customerprofiles_create_domain] or [`update_domain`][customerprofiles_update_domain] to enable identity resolution: set `Matching` to true.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_matches/](https://www.paws-r-sdk.com/docs/customerprofiles_get_matches/) for full documentation.
#'
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_matches
customerprofiles_get_matches <- function(NextToken = NULL, MaxResults = NULL, DomainName) {
  op <- new_operation(
    name = "GetMatches",
    http_method = "GET",
    http_path = "/domains/{DomainName}/matches",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_matches_input(NextToken = NextToken, MaxResults = MaxResults, DomainName = DomainName)
  output <- .customerprofiles$get_matches_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_matches <- customerprofiles_get_matches

#' Returns the object types for a specific domain
#'
#' @description
#' Returns the object types for a specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_profile_object_type/](https://www.paws-r-sdk.com/docs/customerprofiles_get_profile_object_type/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_profile_object_type
customerprofiles_get_profile_object_type <- function(DomainName, ObjectTypeName) {
  op <- new_operation(
    name = "GetProfileObjectType",
    http_method = "GET",
    http_path = "/domains/{DomainName}/object-types/{ObjectTypeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_profile_object_type_input(DomainName = DomainName, ObjectTypeName = ObjectTypeName)
  output <- .customerprofiles$get_profile_object_type_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_profile_object_type <- customerprofiles_get_profile_object_type

#' Returns the template information for a specific object type
#'
#' @description
#' Returns the template information for a specific object type.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_profile_object_type_template/](https://www.paws-r-sdk.com/docs/customerprofiles_get_profile_object_type_template/) for full documentation.
#'
#' @param TemplateId &#91;required&#93; A unique identifier for the object template.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_profile_object_type_template
customerprofiles_get_profile_object_type_template <- function(TemplateId) {
  op <- new_operation(
    name = "GetProfileObjectTypeTemplate",
    http_method = "GET",
    http_path = "/templates/{TemplateId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_profile_object_type_template_input(TemplateId = TemplateId)
  output <- .customerprofiles$get_profile_object_type_template_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_profile_object_type_template <- customerprofiles_get_profile_object_type_template

#' Returns a set of profiles that belong to the same matching group using
#' the matchId or profileId
#'
#' @description
#' Returns a set of profiles that belong to the same matching group using the `matchId` or `profileId`. You can also specify the type of matching that you want for finding similar profiles using either `RULE_BASED_MATCHING` or `ML_BASED_MATCHING`.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_similar_profiles/](https://www.paws-r-sdk.com/docs/customerprofiles_get_similar_profiles/) for full documentation.
#'
#' @param NextToken The pagination token from the previous
#' [`get_similar_profiles`][customerprofiles_get_similar_profiles] API
#' call.
#' @param MaxResults The maximum number of objects returned per page.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param MatchType &#91;required&#93; Specify the type of matching to get similar profiles for.
#' @param SearchKey &#91;required&#93; The string indicating the search key to be used.
#' @param SearchValue &#91;required&#93; The string based on `SearchKey` to be searched for similar profiles.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_similar_profiles
customerprofiles_get_similar_profiles <- function(NextToken = NULL, MaxResults = NULL, DomainName, MatchType, SearchKey, SearchValue) {
  op <- new_operation(
    name = "GetSimilarProfiles",
    http_method = "POST",
    http_path = "/domains/{DomainName}/matches",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_similar_profiles_input(NextToken = NextToken, MaxResults = MaxResults, DomainName = DomainName, MatchType = MatchType, SearchKey = SearchKey, SearchValue = SearchValue)
  output <- .customerprofiles$get_similar_profiles_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_similar_profiles <- customerprofiles_get_similar_profiles

#' Get details of specified workflow
#'
#' @description
#' Get details of specified workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_workflow/](https://www.paws-r-sdk.com/docs/customerprofiles_get_workflow/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param WorkflowId &#91;required&#93; Unique identifier for the workflow.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_workflow
customerprofiles_get_workflow <- function(DomainName, WorkflowId) {
  op <- new_operation(
    name = "GetWorkflow",
    http_method = "GET",
    http_path = "/domains/{DomainName}/workflows/{WorkflowId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_workflow_input(DomainName = DomainName, WorkflowId = WorkflowId)
  output <- .customerprofiles$get_workflow_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_workflow <- customerprofiles_get_workflow

#' Get granular list of steps in workflow
#'
#' @description
#' Get granular list of steps in workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_get_workflow_steps/](https://www.paws-r-sdk.com/docs/customerprofiles_get_workflow_steps/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param WorkflowId &#91;required&#93; Unique identifier for the workflow.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_get_workflow_steps
customerprofiles_get_workflow_steps <- function(DomainName, WorkflowId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetWorkflowSteps",
    http_method = "GET",
    http_path = "/domains/{DomainName}/workflows/{WorkflowId}/steps",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$get_workflow_steps_input(DomainName = DomainName, WorkflowId = WorkflowId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$get_workflow_steps_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$get_workflow_steps <- customerprofiles_get_workflow_steps

#' Lists all of the integrations associated to a specific URI in the AWS
#' account
#'
#' @description
#' Lists all of the integrations associated to a specific URI in the AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_account_integrations/](https://www.paws-r-sdk.com/docs/customerprofiles_list_account_integrations/) for full documentation.
#'
#' @param Uri &#91;required&#93; The URI of the S3 bucket or any other type of data source.
#' @param NextToken The pagination token from the previous ListAccountIntegrations API call.
#' @param MaxResults The maximum number of objects returned per page.
#' @param IncludeHidden Boolean to indicate if hidden integration should be returned. Defaults
#' to `False`.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_account_integrations
customerprofiles_list_account_integrations <- function(Uri, NextToken = NULL, MaxResults = NULL, IncludeHidden = NULL) {
  op <- new_operation(
    name = "ListAccountIntegrations",
    http_method = "POST",
    http_path = "/integrations",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_account_integrations_input(Uri = Uri, NextToken = NextToken, MaxResults = MaxResults, IncludeHidden = IncludeHidden)
  output <- .customerprofiles$list_account_integrations_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_account_integrations <- customerprofiles_list_account_integrations

#' Lists calculated attribute definitions for Customer Profiles
#'
#' @description
#' Lists calculated attribute definitions for Customer Profiles
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_calculated_attribute_definitions/](https://www.paws-r-sdk.com/docs/customerprofiles_list_calculated_attribute_definitions/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param NextToken The pagination token from the previous call to
#' ListCalculatedAttributeDefinitions.
#' @param MaxResults The maximum number of calculated attribute definitions returned per
#' page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_calculated_attribute_definitions
customerprofiles_list_calculated_attribute_definitions <- function(DomainName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCalculatedAttributeDefinitions",
    http_method = "GET",
    http_path = "/domains/{DomainName}/calculated-attributes",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_calculated_attribute_definitions_input(DomainName = DomainName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_calculated_attribute_definitions_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_calculated_attribute_definitions <- customerprofiles_list_calculated_attribute_definitions

#' Retrieve a list of calculated attributes for a customer profile
#'
#' @description
#' Retrieve a list of calculated attributes for a customer profile.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_calculated_attributes_for_profile/](https://www.paws-r-sdk.com/docs/customerprofiles_list_calculated_attributes_for_profile/) for full documentation.
#'
#' @param NextToken The pagination token from the previous call to
#' ListCalculatedAttributesForProfile.
#' @param MaxResults The maximum number of calculated attributes returned per page.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_calculated_attributes_for_profile
customerprofiles_list_calculated_attributes_for_profile <- function(NextToken = NULL, MaxResults = NULL, DomainName, ProfileId) {
  op <- new_operation(
    name = "ListCalculatedAttributesForProfile",
    http_method = "GET",
    http_path = "/domains/{DomainName}/profile/{ProfileId}/calculated-attributes",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_calculated_attributes_for_profile_input(NextToken = NextToken, MaxResults = MaxResults, DomainName = DomainName, ProfileId = ProfileId)
  output <- .customerprofiles$list_calculated_attributes_for_profile_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_calculated_attributes_for_profile <- customerprofiles_list_calculated_attributes_for_profile

#' Returns a list of all the domains for an AWS account that have been
#' created
#'
#' @description
#' Returns a list of all the domains for an AWS account that have been created.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_domains/](https://www.paws-r-sdk.com/docs/customerprofiles_list_domains/) for full documentation.
#'
#' @param NextToken The pagination token from the previous ListDomain API call.
#' @param MaxResults The maximum number of objects returned per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_domains
customerprofiles_list_domains <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "GET",
    http_path = "/domains",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_domains_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_domains_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_domains <- customerprofiles_list_domains

#' Returns a list of all the event streams in a specific domain
#'
#' @description
#' Returns a list of all the event streams in a specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_event_streams/](https://www.paws-r-sdk.com/docs/customerprofiles_list_event_streams/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of objects returned per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_event_streams
customerprofiles_list_event_streams <- function(DomainName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEventStreams",
    http_method = "GET",
    http_path = "/domains/{DomainName}/event-streams",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Items")
  )
  input <- .customerprofiles$list_event_streams_input(DomainName = DomainName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_event_streams_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_event_streams <- customerprofiles_list_event_streams

#' Lists all of the Identity Resolution Jobs in your domain
#'
#' @description
#' Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by `JobStartTime`.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_identity_resolution_jobs/](https://www.paws-r-sdk.com/docs/customerprofiles_list_identity_resolution_jobs/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_identity_resolution_jobs
customerprofiles_list_identity_resolution_jobs <- function(DomainName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListIdentityResolutionJobs",
    http_method = "GET",
    http_path = "/domains/{DomainName}/identity-resolution-jobs",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_identity_resolution_jobs_input(DomainName = DomainName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_identity_resolution_jobs_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_identity_resolution_jobs <- customerprofiles_list_identity_resolution_jobs

#' Lists all of the integrations in your domain
#'
#' @description
#' Lists all of the integrations in your domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_integrations/](https://www.paws-r-sdk.com/docs/customerprofiles_list_integrations/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param NextToken The pagination token from the previous ListIntegrations API call.
#' @param MaxResults The maximum number of objects returned per page.
#' @param IncludeHidden Boolean to indicate if hidden integration should be returned. Defaults
#' to `False`.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_integrations
customerprofiles_list_integrations <- function(DomainName, NextToken = NULL, MaxResults = NULL, IncludeHidden = NULL) {
  op <- new_operation(
    name = "ListIntegrations",
    http_method = "GET",
    http_path = "/domains/{DomainName}/integrations",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_integrations_input(DomainName = DomainName, NextToken = NextToken, MaxResults = MaxResults, IncludeHidden = IncludeHidden)
  output <- .customerprofiles$list_integrations_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_integrations <- customerprofiles_list_integrations

#' Lists all of the template information for object types
#'
#' @description
#' Lists all of the template information for object types.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_profile_object_type_templates/](https://www.paws-r-sdk.com/docs/customerprofiles_list_profile_object_type_templates/) for full documentation.
#'
#' @param NextToken The pagination token from the previous ListObjectTypeTemplates API call.
#' @param MaxResults The maximum number of objects returned per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_profile_object_type_templates
customerprofiles_list_profile_object_type_templates <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProfileObjectTypeTemplates",
    http_method = "GET",
    http_path = "/templates",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_profile_object_type_templates_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_profile_object_type_templates_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_profile_object_type_templates <- customerprofiles_list_profile_object_type_templates

#' Lists all of the templates available within the service
#'
#' @description
#' Lists all of the templates available within the service.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_profile_object_types/](https://www.paws-r-sdk.com/docs/customerprofiles_list_profile_object_types/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param NextToken Identifies the next page of results to return.
#' @param MaxResults The maximum number of objects returned per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_profile_object_types
customerprofiles_list_profile_object_types <- function(DomainName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProfileObjectTypes",
    http_method = "GET",
    http_path = "/domains/{DomainName}/object-types",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_profile_object_types_input(DomainName = DomainName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_profile_object_types_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_profile_object_types <- customerprofiles_list_profile_object_types

#' Returns a list of objects associated with a profile of a given
#' ProfileObjectType
#'
#' @description
#' Returns a list of objects associated with a profile of a given ProfileObjectType.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_profile_objects/](https://www.paws-r-sdk.com/docs/customerprofiles_list_profile_objects/) for full documentation.
#'
#' @param NextToken The pagination token from the previous call to ListProfileObjects.
#' @param MaxResults The maximum number of objects returned per page.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param ObjectFilter Applies a filter to the response to include profile objects with the
#' specified index values.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_profile_objects
customerprofiles_list_profile_objects <- function(NextToken = NULL, MaxResults = NULL, DomainName, ObjectTypeName, ProfileId, ObjectFilter = NULL) {
  op <- new_operation(
    name = "ListProfileObjects",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/objects",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_profile_objects_input(NextToken = NextToken, MaxResults = MaxResults, DomainName = DomainName, ObjectTypeName = ObjectTypeName, ProfileId = ProfileId, ObjectFilter = ObjectFilter)
  output <- .customerprofiles$list_profile_objects_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_profile_objects <- customerprofiles_list_profile_objects

#' Returns a set of MatchIds that belong to the given domain
#'
#' @description
#' Returns a set of `MatchIds` that belong to the given domain.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_rule_based_matches/](https://www.paws-r-sdk.com/docs/customerprofiles_list_rule_based_matches/) for full documentation.
#'
#' @param NextToken The pagination token from the previous
#' [`list_rule_based_matches`][customerprofiles_list_rule_based_matches]
#' API call.
#' @param MaxResults The maximum number of `MatchIds` returned per page.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_rule_based_matches
customerprofiles_list_rule_based_matches <- function(NextToken = NULL, MaxResults = NULL, DomainName) {
  op <- new_operation(
    name = "ListRuleBasedMatches",
    http_method = "GET",
    http_path = "/domains/{DomainName}/profiles/ruleBasedMatches",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_rule_based_matches_input(NextToken = NextToken, MaxResults = MaxResults, DomainName = DomainName)
  output <- .customerprofiles$list_rule_based_matches_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_rule_based_matches <- customerprofiles_list_rule_based_matches

#' Displays the tags associated with an Amazon Connect Customer Profiles
#' resource
#'
#' @description
#' Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/customerprofiles_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource for which you want to view tags.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_tags_for_resource
customerprofiles_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .customerprofiles$list_tags_for_resource_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_tags_for_resource <- customerprofiles_list_tags_for_resource

#' Query to list all workflows
#'
#' @description
#' Query to list all workflows.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_list_workflows/](https://www.paws-r-sdk.com/docs/customerprofiles_list_workflows/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param WorkflowType The type of workflow. The only supported value is APPFLOW_INTEGRATION.
#' @param Status Status of workflow execution.
#' @param QueryStartDate Retrieve workflows started after timestamp.
#' @param QueryEndDate Retrieve workflows ended after timestamp.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_list_workflows
customerprofiles_list_workflows <- function(DomainName, WorkflowType = NULL, Status = NULL, QueryStartDate = NULL, QueryEndDate = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkflows",
    http_method = "POST",
    http_path = "/domains/{DomainName}/workflows",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$list_workflows_input(DomainName = DomainName, WorkflowType = WorkflowType, Status = Status, QueryStartDate = QueryStartDate, QueryEndDate = QueryEndDate, NextToken = NextToken, MaxResults = MaxResults)
  output <- .customerprofiles$list_workflows_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$list_workflows <- customerprofiles_list_workflows

#' Runs an AWS Lambda job that does the following:
#'
#' @description
#' Runs an AWS Lambda job that does the following:
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_merge_profiles/](https://www.paws-r-sdk.com/docs/customerprofiles_merge_profiles/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param MainProfileId &#91;required&#93; The identifier of the profile to be taken.
#' @param ProfileIdsToBeMerged &#91;required&#93; The identifier of the profile to be merged into MainProfileId.
#' @param FieldSourceProfileIds The identifiers of the fields in the profile that has the information
#' you want to apply to the merge. For example, say you want to merge
#' EmailAddress from Profile1 into MainProfile. This would be the
#' identifier of the EmailAddress field in Profile1.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_merge_profiles
customerprofiles_merge_profiles <- function(DomainName, MainProfileId, ProfileIdsToBeMerged, FieldSourceProfileIds = NULL) {
  op <- new_operation(
    name = "MergeProfiles",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/objects/merge",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$merge_profiles_input(DomainName = DomainName, MainProfileId = MainProfileId, ProfileIdsToBeMerged = ProfileIdsToBeMerged, FieldSourceProfileIds = FieldSourceProfileIds)
  output <- .customerprofiles$merge_profiles_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$merge_profiles <- customerprofiles_merge_profiles

#' Adds an integration between the service and a third-party service, which
#' includes Amazon AppFlow and Amazon Connect
#'
#' @description
#' Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_put_integration/](https://www.paws-r-sdk.com/docs/customerprofiles_put_integration/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param Uri The URI of the S3 bucket or any other type of data source.
#' @param ObjectTypeName The name of the profile object type.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' @param FlowDefinition The configuration that controls how Customer Profiles retrieves data
#' from the source.
#' @param ObjectTypeNames A map in which each key is an event type from an external application
#' such as Segment or Shopify, and each value is an `ObjectTypeName`
#' (template) used to ingest the event. It supports the following event
#' types: `SegmentIdentify`, `ShopifyCreateCustomers`,
#' `ShopifyUpdateCustomers`, `ShopifyCreateDraftOrders`,
#' `ShopifyUpdateDraftOrders`, `ShopifyCreateOrders`, and
#' `ShopifyUpdatedOrders`.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_put_integration
customerprofiles_put_integration <- function(DomainName, Uri = NULL, ObjectTypeName = NULL, Tags = NULL, FlowDefinition = NULL, ObjectTypeNames = NULL) {
  op <- new_operation(
    name = "PutIntegration",
    http_method = "PUT",
    http_path = "/domains/{DomainName}/integrations",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$put_integration_input(DomainName = DomainName, Uri = Uri, ObjectTypeName = ObjectTypeName, Tags = Tags, FlowDefinition = FlowDefinition, ObjectTypeNames = ObjectTypeNames)
  output <- .customerprofiles$put_integration_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$put_integration <- customerprofiles_put_integration

#' Adds additional objects to customer profiles of a given ObjectType
#'
#' @description
#' Adds additional objects to customer profiles of a given ObjectType.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_put_profile_object/](https://www.paws-r-sdk.com/docs/customerprofiles_put_profile_object/) for full documentation.
#'
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#' @param Object &#91;required&#93; A string that is serialized from a JSON object.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_put_profile_object
customerprofiles_put_profile_object <- function(ObjectTypeName, Object, DomainName) {
  op <- new_operation(
    name = "PutProfileObject",
    http_method = "PUT",
    http_path = "/domains/{DomainName}/profiles/objects",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$put_profile_object_input(ObjectTypeName = ObjectTypeName, Object = Object, DomainName = DomainName)
  output <- .customerprofiles$put_profile_object_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$put_profile_object <- customerprofiles_put_profile_object

#' Defines a ProfileObjectType
#'
#' @description
#' Defines a ProfileObjectType.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_put_profile_object_type/](https://www.paws-r-sdk.com/docs/customerprofiles_put_profile_object_type/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ObjectTypeName &#91;required&#93; The name of the profile object type.
#' @param Description &#91;required&#93; Description of the profile object type.
#' @param TemplateId A unique identifier for the object template. For some attributes in the
#' request, the service will use the default value from the object template
#' when TemplateId is present. If these attributes are present in the
#' request, the service may return a `BadRequestException`. These
#' attributes include: AllowProfileCreation,
#' SourceLastUpdatedTimestampFormat, Fields, and Keys. For example, if
#' AllowProfileCreation is set to true when TemplateId is set, the service
#' may return a `BadRequestException`.
#' @param ExpirationDays The number of days until the data in the object expires.
#' @param EncryptionKey The customer-provided key to encrypt the profile object that will be
#' created in this profile object type.
#' @param AllowProfileCreation Indicates whether a profile should be created when data is received if
#' one doesn’t exist for an object of this type. The default is `FALSE`. If
#' the AllowProfileCreation flag is set to `FALSE`, then the service tries
#' to fetch a standard profile and associate this object with the profile.
#' If it is set to `TRUE`, and if no match is found, then the service
#' creates a new standard profile.
#' @param SourceLastUpdatedTimestampFormat The format of your `sourceLastUpdatedTimestamp` that was previously set
#' up.
#' @param MaxProfileObjectCount The amount of profile object max count assigned to the object type
#' @param Fields A map of the name and ObjectType field.
#' @param Keys A list of unique keys that can be used to map data to the profile.
#' @param Tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_put_profile_object_type
customerprofiles_put_profile_object_type <- function(DomainName, ObjectTypeName, Description, TemplateId = NULL, ExpirationDays = NULL, EncryptionKey = NULL, AllowProfileCreation = NULL, SourceLastUpdatedTimestampFormat = NULL, MaxProfileObjectCount = NULL, Fields = NULL, Keys = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PutProfileObjectType",
    http_method = "PUT",
    http_path = "/domains/{DomainName}/object-types/{ObjectTypeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$put_profile_object_type_input(DomainName = DomainName, ObjectTypeName = ObjectTypeName, Description = Description, TemplateId = TemplateId, ExpirationDays = ExpirationDays, EncryptionKey = EncryptionKey, AllowProfileCreation = AllowProfileCreation, SourceLastUpdatedTimestampFormat = SourceLastUpdatedTimestampFormat, MaxProfileObjectCount = MaxProfileObjectCount, Fields = Fields, Keys = Keys, Tags = Tags)
  output <- .customerprofiles$put_profile_object_type_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$put_profile_object_type <- customerprofiles_put_profile_object_type

#' Searches for profiles within a specific domain using one or more
#' predefined search keys (e
#'
#' @description
#' Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone, _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a `KeyName` and `Values` list.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_search_profiles/](https://www.paws-r-sdk.com/docs/customerprofiles_search_profiles/) for full documentation.
#'
#' @param NextToken The pagination token from the previous SearchProfiles API call.
#' @param MaxResults The maximum number of objects returned per page.
#' 
#' The default is 20 if this parameter is not included in the request.
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param KeyName &#91;required&#93; A searchable identifier of a customer profile. The predefined keys you
#' can use to search include: _account, _profileId, _assetId, _caseId,
#' _orderId, _fullName, _phone, _email, _ctrContactId,
#' _marketoLeadId, _salesforceAccountId, _salesforceContactId,
#' _salesforceAssetId, _zendeskUserId, _zendeskExternalId,
#' _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId,
#' _segmentUserId, _shopifyCustomerId, _shopifyOrderId.
#' @param Values &#91;required&#93; A list of key values.
#' @param AdditionalSearchKeys A list of `AdditionalSearchKey` objects that are each searchable
#' identifiers of a profile. Each `AdditionalSearchKey` object contains a
#' `KeyName` and a list of `Values` associated with that specific key
#' (i.e., a key-value(s) pair). These additional search keys will be used
#' in conjunction with the `LogicalOperator` and the required `KeyName` and
#' `Values` parameters to search for profiles that satisfy the search
#' criteria.
#' @param LogicalOperator Relationship between all specified search keys that will be used to
#' search for profiles. This includes the required `KeyName` and `Values`
#' parameters as well as any key-value(s) pairs specified in the
#' `AdditionalSearchKeys` list.
#' 
#' This parameter influences which profiles will be returned in the
#' response in the following manner:
#' 
#' -   `AND` - The response only includes profiles that match all of the
#'     search keys.
#' 
#' -   `OR` - The response includes profiles that match at least one of the
#'     search keys.
#' 
#' The `OR` relationship is the default behavior if this parameter is not
#' included in the request.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_search_profiles
customerprofiles_search_profiles <- function(NextToken = NULL, MaxResults = NULL, DomainName, KeyName, Values, AdditionalSearchKeys = NULL, LogicalOperator = NULL) {
  op <- new_operation(
    name = "SearchProfiles",
    http_method = "POST",
    http_path = "/domains/{DomainName}/profiles/search",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$search_profiles_input(NextToken = NextToken, MaxResults = MaxResults, DomainName = DomainName, KeyName = KeyName, Values = Values, AdditionalSearchKeys = AdditionalSearchKeys, LogicalOperator = LogicalOperator)
  output <- .customerprofiles$search_profiles_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$search_profiles <- customerprofiles_search_profiles

#' Assigns one or more tags (key-value pairs) to the specified Amazon
#' Connect Customer Profiles resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_tag_resource/](https://www.paws-r-sdk.com/docs/customerprofiles_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that you're adding tags to.
#' @param tags &#91;required&#93; The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_tag_resource
customerprofiles_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .customerprofiles$tag_resource_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$tag_resource <- customerprofiles_tag_resource

#' Removes one or more tags from the specified Amazon Connect Customer
#' Profiles resource
#'
#' @description
#' Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_untag_resource/](https://www.paws-r-sdk.com/docs/customerprofiles_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource from which you are removing tags.
#' @param tagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_untag_resource
customerprofiles_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .customerprofiles$untag_resource_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$untag_resource <- customerprofiles_untag_resource

#' Updates an existing calculated attribute definition
#'
#' @description
#' Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date range of a calculated attribute will not trigger inclusion of historical data greater than the current date range.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_update_calculated_attribute_definition/](https://www.paws-r-sdk.com/docs/customerprofiles_update_calculated_attribute_definition/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param CalculatedAttributeName &#91;required&#93; The unique name of the calculated attribute.
#' @param DisplayName The display name of the calculated attribute.
#' @param Description The description of the calculated attribute.
#' @param Conditions The conditions including range, object count, and threshold for the
#' calculated attribute.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_update_calculated_attribute_definition
customerprofiles_update_calculated_attribute_definition <- function(DomainName, CalculatedAttributeName, DisplayName = NULL, Description = NULL, Conditions = NULL) {
  op <- new_operation(
    name = "UpdateCalculatedAttributeDefinition",
    http_method = "PUT",
    http_path = "/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$update_calculated_attribute_definition_input(DomainName = DomainName, CalculatedAttributeName = CalculatedAttributeName, DisplayName = DisplayName, Description = Description, Conditions = Conditions)
  output <- .customerprofiles$update_calculated_attribute_definition_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$update_calculated_attribute_definition <- customerprofiles_update_calculated_attribute_definition

#' Updates the properties of a domain, including creating or selecting a
#' dead letter queue or an encryption key
#'
#' @description
#' Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_update_domain/](https://www.paws-r-sdk.com/docs/customerprofiles_update_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param DefaultExpirationDays The default number of days until the data within the domain expires.
#' @param DefaultEncryptionKey The default encryption key, which is an AWS managed key, is used when no
#' specific type of encryption key is specified. It is used to encrypt all
#' data before it is placed in permanent or semi-permanent storage. If
#' specified as an empty string, it will clear any existing value.
#' @param DeadLetterQueueUrl The URL of the SQS dead letter queue, which is used for reporting errors
#' associated with ingesting data from third party applications. If
#' specified as an empty string, it will clear any existing value. You must
#' set up a policy on the DeadLetterQueue for the SendMessage operation to
#' enable Amazon Connect Customer Profiles to send messages to the
#' DeadLetterQueue.
#' @param Matching The process of matching duplicate profiles. If `Matching` = `true`,
#' Amazon Connect Customer Profiles starts a weekly batch process called
#' Identity Resolution Job. If you do not specify a date and time for
#' Identity Resolution Job to run, by default it runs every Saturday at
#' 12AM UTC to detect duplicate profiles in your domains.
#' 
#' After the Identity Resolution Job completes, use the
#' [`get_matches`][customerprofiles_get_matches] API to return and review
#' the results. Or, if you have configured `ExportingConfig` in the
#' `MatchingRequest`, you can download the results from S3.
#' @param RuleBasedMatching The process of matching duplicate profiles using the rule-Based
#' matching. If `RuleBasedMatching` = true, Amazon Connect Customer
#' Profiles will start to match and merge your profiles according to your
#' configuration in the `RuleBasedMatchingRequest`. You can use the
#' [`list_rule_based_matches`][customerprofiles_list_rule_based_matches]
#' and [`get_similar_profiles`][customerprofiles_get_similar_profiles] API
#' to return and review the results. Also, if you have configured
#' `ExportingConfig` in the `RuleBasedMatchingRequest`, you can download
#' the results from S3.
#' @param Tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_update_domain
customerprofiles_update_domain <- function(DomainName, DefaultExpirationDays = NULL, DefaultEncryptionKey = NULL, DeadLetterQueueUrl = NULL, Matching = NULL, RuleBasedMatching = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "PUT",
    http_path = "/domains/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$update_domain_input(DomainName = DomainName, DefaultExpirationDays = DefaultExpirationDays, DefaultEncryptionKey = DefaultEncryptionKey, DeadLetterQueueUrl = DeadLetterQueueUrl, Matching = Matching, RuleBasedMatching = RuleBasedMatching, Tags = Tags)
  output <- .customerprofiles$update_domain_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$update_domain <- customerprofiles_update_domain

#' Updates the properties of a profile
#'
#' @description
#' Updates the properties of a profile. The ProfileId is required for updating a customer profile.
#'
#' See [https://www.paws-r-sdk.com/docs/customerprofiles_update_profile/](https://www.paws-r-sdk.com/docs/customerprofiles_update_profile/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The unique name of the domain.
#' @param ProfileId &#91;required&#93; The unique identifier of a customer profile.
#' @param AdditionalInformation Any additional information relevant to the customer’s profile.
#' @param AccountNumber An account number that you have given to the customer.
#' @param PartyType The type of profile used to describe the customer.
#' @param BusinessName The name of the customer’s business.
#' @param FirstName The customer’s first name.
#' @param MiddleName The customer’s middle name.
#' @param LastName The customer’s last name.
#' @param BirthDate The customer’s birth date.
#' @param Gender The gender with which the customer identifies.
#' @param PhoneNumber The customer’s phone number, which has not been specified as a mobile,
#' home, or business number.
#' @param MobilePhoneNumber The customer’s mobile phone number.
#' @param HomePhoneNumber The customer’s home phone number.
#' @param BusinessPhoneNumber The customer’s business phone number.
#' @param EmailAddress The customer’s email address, which has not been specified as a personal
#' or business address.
#' @param PersonalEmailAddress The customer’s personal email address.
#' @param BusinessEmailAddress The customer’s business email address.
#' @param Address A generic address associated with the customer that is not mailing,
#' shipping, or billing.
#' @param ShippingAddress The customer’s shipping address.
#' @param MailingAddress The customer’s mailing address.
#' @param BillingAddress The customer’s billing address.
#' @param Attributes A key value pair of attributes of a customer profile.
#' @param PartyTypeString An alternative to `PartyType` which accepts any string as input.
#' @param GenderString An alternative to `Gender` which accepts any string as input.
#'
#' @keywords internal
#'
#' @rdname customerprofiles_update_profile
customerprofiles_update_profile <- function(DomainName, ProfileId, AdditionalInformation = NULL, AccountNumber = NULL, PartyType = NULL, BusinessName = NULL, FirstName = NULL, MiddleName = NULL, LastName = NULL, BirthDate = NULL, Gender = NULL, PhoneNumber = NULL, MobilePhoneNumber = NULL, HomePhoneNumber = NULL, BusinessPhoneNumber = NULL, EmailAddress = NULL, PersonalEmailAddress = NULL, BusinessEmailAddress = NULL, Address = NULL, ShippingAddress = NULL, MailingAddress = NULL, BillingAddress = NULL, Attributes = NULL, PartyTypeString = NULL, GenderString = NULL) {
  op <- new_operation(
    name = "UpdateProfile",
    http_method = "PUT",
    http_path = "/domains/{DomainName}/profiles",
    host_prefix = "",
    paginator = list()
  )
  input <- .customerprofiles$update_profile_input(DomainName = DomainName, ProfileId = ProfileId, AdditionalInformation = AdditionalInformation, AccountNumber = AccountNumber, PartyType = PartyType, BusinessName = BusinessName, FirstName = FirstName, MiddleName = MiddleName, LastName = LastName, BirthDate = BirthDate, Gender = Gender, PhoneNumber = PhoneNumber, MobilePhoneNumber = MobilePhoneNumber, HomePhoneNumber = HomePhoneNumber, BusinessPhoneNumber = BusinessPhoneNumber, EmailAddress = EmailAddress, PersonalEmailAddress = PersonalEmailAddress, BusinessEmailAddress = BusinessEmailAddress, Address = Address, ShippingAddress = ShippingAddress, MailingAddress = MailingAddress, BillingAddress = BillingAddress, Attributes = Attributes, PartyTypeString = PartyTypeString, GenderString = GenderString)
  output <- .customerprofiles$update_profile_output()
  config <- get_config()
  svc <- .customerprofiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.customerprofiles$operations$update_profile <- customerprofiles_update_profile
