% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dax_operations.R
\name{dax_untag_resource}
\alias{dax_untag_resource}
\title{Removes the association of tags from a DAX resource}
\usage{
dax_untag_resource(ResourceName, TagKeys)
}
\arguments{
\item{ResourceName}{[required] The name of the DAX resource from which the tags should be removed.}

\item{TagKeys}{[required] A list of tag keys. If the DAX cluster has any tags with these keys,
then the tags are removed from the cluster.}
}
\description{
Removes the association of tags from a DAX resource. You can call
\code{UntagResource} up to 5 times per second, per account.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceName = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
