% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_snapshot_attribute}
\alias{rds_modify_db_snapshot_attribute}
\title{Adds an attribute and values to, or removes an attribute and values
from, a manual DB snapshot}
\usage{
rds_modify_db_snapshot_attribute(DBSnapshotIdentifier, AttributeName,
  ValuesToAdd, ValuesToRemove)
}
\arguments{
\item{DBSnapshotIdentifier}{[required] The identifier for the DB snapshot to modify the attributes for.}

\item{AttributeName}{[required] The name of the DB snapshot attribute to modify.

To manage authorization for other AWS accounts to copy or restore a
manual DB snapshot, set this value to \code{restore}.}

\item{ValuesToAdd}{A list of DB snapshot attributes to add to the attribute specified by
\code{AttributeName}.

To authorize other AWS accounts to copy or restore a manual snapshot,
set this list to include one or more AWS account IDs, or \code{all} to make
the manual DB snapshot restorable by any AWS account. Do not add the
\code{all} value for any manual DB snapshots that contain private information
that you don't want available to all AWS accounts.}

\item{ValuesToRemove}{A list of DB snapshot attributes to remove from the attribute specified
by \code{AttributeName}.

To remove authorization for other AWS accounts to copy or restore a
manual snapshot, set this list to include one or more AWS account
identifiers, or \code{all} to remove authorization for any AWS account to
copy or restore the DB snapshot. If you specify \code{all}, an AWS account
whose account ID is explicitly added to the \code{restore} attribute can
still copy or restore the manual DB snapshot.}
}
\description{
Adds an attribute and values to, or removes an attribute and values
from, a manual DB snapshot.
}
\details{
To share a manual DB snapshot with other AWS accounts, specify \code{restore}
as the \code{AttributeName} and use the \code{ValuesToAdd} parameter to add a list
of IDs of the AWS accounts that are authorized to restore the manual DB
snapshot. Uses the value \code{all} to make the manual DB snapshot public,
which means it can be copied or restored by all AWS accounts. Do not add
the \code{all} value for any manual DB snapshots that contain private
information that you don't want available to all AWS accounts. If the
manual DB snapshot is encrypted, it can be shared, but only by
specifying a list of authorized AWS account IDs for the \code{ValuesToAdd}
parameter. You can't use \code{all} as a value for that parameter in this
case.

To view which AWS accounts have access to copy or restore a manual DB
snapshot, or whether a manual DB snapshot public or private, use the
DescribeDBSnapshotAttributes API action.
}
\section{Request syntax}{
\preformatted{svc$modify_db_snapshot_attribute(
  DBSnapshotIdentifier = "string",
  AttributeName = "string",
  ValuesToAdd = list(
    "string"
  ),
  ValuesToRemove = list(
    "string"
  )
)
}
}

\keyword{internal}
