% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_cluster_versions}
\alias{redshift_describe_cluster_versions}
\title{Returns descriptions of the available Amazon Redshift cluster versions}
\usage{
redshift_describe_cluster_versions(ClusterVersion,
  ClusterParameterGroupFamily, MaxRecords, Marker)
}
\arguments{
\item{ClusterVersion}{The specific cluster version to return.

Example: \code{1.0}}

\item{ClusterParameterGroupFamily}{The name of a specific cluster parameter group family to return details
for.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeClusterVersions
request exceed the value specified in \code{MaxRecords}, AWS returns a value
in the \code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.}
}
\description{
Returns descriptions of the available Amazon Redshift cluster versions.
You can call this operation even before creating any clusters to learn
more about the Amazon Redshift versions. For more information about
managing clusters, go to \href{http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html}{Amazon Redshift Clusters}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster_versions(
  ClusterVersion = "string",
  ClusterParameterGroupFamily = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
