% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_execute_statement}
\alias{dynamodb_execute_statement}
\title{This operation allows you to perform reads and singleton writes on data
stored in DynamoDB, using PartiQL}
\usage{
dynamodb_execute_statement(Statement, Parameters, ConsistentRead,
  NextToken)
}
\arguments{
\item{Statement}{[required] The PartiQL statement representing the operation to run.}

\item{Parameters}{The parameters for the PartiQL statement, if any.}

\item{ConsistentRead}{The consistency of a read operation. If set to \code{true}, then a strongly
consistent read is used; otherwise, an eventually consistent read is
used.}

\item{NextToken}{Set this value to get remaining results, if \code{NextToken} was returned in
the statement response.}
}
\description{
This operation allows you to perform reads and singleton writes on data
stored in DynamoDB, using PartiQL.
}
\section{Request syntax}{
\preformatted{svc$execute_statement(
  Statement = "string",
  Parameters = list(
    list(
      S = "string",
      N = "string",
      B = raw,
      SS = list(
        "string"
      ),
      NS = list(
        "string"
      ),
      BS = list(
        raw
      ),
      M = list(
        list()
      ),
      L = list(
        list()
      ),
      NULL = TRUE|FALSE,
      BOOL = TRUE|FALSE
    )
  ),
  ConsistentRead = TRUE|FALSE,
  NextToken = "string"
)
}
}

\keyword{internal}
