% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_from_s3}
\alias{rds_restore_db_cluster_from_s3}
\title{Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon
S3 bucket}
\usage{
rds_restore_db_cluster_from_s3(AvailabilityZones, BackupRetentionPeriod,
  CharacterSetName, DatabaseName, DBClusterIdentifier,
  DBClusterParameterGroupName, VpcSecurityGroupIds, DBSubnetGroupName,
  Engine, EngineVersion, Port, MasterUsername, MasterUserPassword,
  OptionGroupName, PreferredBackupWindow, PreferredMaintenanceWindow,
  Tags, StorageEncrypted, KmsKeyId, EnableIAMDatabaseAuthentication,
  SourceEngine, SourceEngineVersion, S3BucketName, S3Prefix,
  S3IngestionRoleArn, BacktrackWindow, EnableCloudwatchLogsExports,
  DeletionProtection, CopyTagsToSnapshot, Domain, DomainIAMRoleName)
}
\arguments{
\item{AvailabilityZones}{A list of Availability Zones (AZs) where instances in the restored DB
cluster can be created.}

\item{BackupRetentionPeriod}{The number of days for which automated backups of the restored DB
cluster are retained. You must specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{CharacterSetName}{A value that indicates that the restored DB cluster should be associated
with the specified CharacterSet.}

\item{DatabaseName}{The database name for the restored DB cluster.}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the source data in the Amazon
S3 bucket. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with the
restored DB cluster. If this argument is omitted, \code{default.aurora5.6} is
used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the restored DB
cluster.}

\item{DBSubnetGroupName}{A DB subnet group to associate with the restored DB cluster.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{Engine}{[required] The name of the database engine to be used for this DB cluster.

Valid Values: \code{aurora} (for MySQL 5.6-compatible Aurora), \code{aurora-mysql}
(for MySQL 5.7-compatible Aurora), and \code{aurora-postgresql}}

\item{EngineVersion}{The version number of the database engine to use.

To list all of the available engine versions for \code{aurora} (for MySQL
5.6-compatible Aurora), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions\\\[\\\].EngineVersion"}

To list all of the available engine versions for \code{aurora-mysql} (for
MySQL 5.7-compatible Aurora), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions\\\[\\\].EngineVersion"}

To list all of the available engine versions for \code{aurora-postgresql},
use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions\\\[\\\].EngineVersion"}

\strong{Aurora MySQL}

Example: \verb{5.6.10a}, \verb{5.6.mysql_aurora.1.19.2}, \verb{5.7.12},
\verb{5.7.mysql_aurora.2.04.5}

\strong{Aurora PostgreSQL}

Example: \verb{9.6.3}, \code{10.7}}

\item{Port}{The port number on which the instances in the restored DB cluster accept
connections.

Default: \code{3306}}

\item{MasterUsername}{[required] The name of the master user for the restored DB cluster.

Constraints:
\itemize{
\item Must be 1 to 16 letters or numbers.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{[required] The password for the master database user. This password can contain any
printable ASCII character except "/", """, or "@".

Constraints: Must contain from 8 to 41 characters.}

\item{OptionGroupName}{A value that indicates that the restored DB cluster should be associated
with the specified option group.

Permanent options can't be removed from an option group. An option group
can't be removed from a DB cluster once it is associated with a DB
cluster.}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region. To see the time blocks available, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred Maintenance Window}
in the \emph{Amazon Aurora User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred Maintenance Window}
in the \emph{Amazon Aurora User Guide.}

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{Tags}{}

\item{StorageEncrypted}{A value that indicates whether the restored DB cluster is encrypted.}

\item{KmsKeyId}{The AWS KMS key identifier for an encrypted DB cluster.

The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias
name for the AWS KMS customer master key (CMK). To use a CMK in a
different AWS account, specify the key ARN or alias ARN.

If the StorageEncrypted parameter is enabled, and you do not specify a
value for the \code{KmsKeyId} parameter, then Amazon RDS will use your
default CMK. There is a default CMK for your AWS account. Your AWS
account has a different default CMK for each AWS Region.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide.}}

\item{SourceEngine}{[required] The identifier for the database engine that was backed up to create the
files stored in the Amazon S3 bucket.

Valid values: \code{mysql}}

\item{SourceEngineVersion}{[required] The version of the database that the backup files were created from.

MySQL versions 5.5, 5.6, and 5.7 are supported.

Example: \verb{5.6.40}, \verb{5.7.28}}

\item{S3BucketName}{[required] The name of the Amazon S3 bucket that contains the data used to create
the Amazon Aurora DB cluster.}

\item{S3Prefix}{The prefix for all of the file names that contain the data used to
create the Amazon Aurora DB cluster. If you do not specify a
\strong{SourceS3Prefix} value, then the Amazon Aurora DB cluster is created
by using all of the files in the Amazon S3 bucket.}

\item{S3IngestionRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on
your behalf.}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Currently, Backtrack is only supported for Aurora MySQL DB clusters.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to CloudWatch
Logs. The values in the list depend on the DB engine being used. For
more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
cluster to snapshots of the restored DB cluster. The default is not to
copy them.}

\item{Domain}{Specify the Active Directory directory ID to restore the DB cluster in.
The domain must be created prior to this operation.

For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
Authentication to authenticate users that connect to the DB cluster. For
more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon Aurora User Guide}.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}
}
\description{
Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon
S3 bucket. Amazon RDS must be authorized to access the Amazon S3 bucket
and the data must be created using the Percona XtraBackup utility as
described in \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3}{Migrating Data from MySQL by Using an Amazon S3 Bucket}
in the \emph{Amazon Aurora User Guide}.

This action only restores the DB cluster, not the DB instances for that
DB cluster. You must invoke the \code{CreateDBInstance} action to create DB
instances for the restored DB cluster, specifying the identifier of the
restored DB cluster in \code{DBClusterIdentifier}. You can create DB
instances only after the \code{RestoreDBClusterFromS3} action has completed
and the DB cluster is available.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters. The source DB engine
must be MySQL.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_from_s3(
  AvailabilityZones = list(
    "string"
  ),
  BackupRetentionPeriod = 123,
  CharacterSetName = "string",
  DatabaseName = "string",
  DBClusterIdentifier = "string",
  DBClusterParameterGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  DBSubnetGroupName = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  MasterUsername = "string",
  MasterUserPassword = "string",
  OptionGroupName = "string",
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageEncrypted = TRUE|FALSE,
  KmsKeyId = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  SourceEngine = "string",
  SourceEngineVersion = "string",
  S3BucketName = "string",
  S3Prefix = "string",
  S3IngestionRoleArn = "string",
  BacktrackWindow = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DeletionProtection = TRUE|FALSE,
  CopyTagsToSnapshot = TRUE|FALSE,
  Domain = "string",
  DomainIAMRoleName = "string"
)
}
}

\keyword{internal}
