% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_db_instances}
\alias{docdb_describe_db_instances}
\title{Returns information about provisioned Amazon DocumentDB instances}
\usage{
docdb_describe_db_instances(DBInstanceIdentifier, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{DBInstanceIdentifier}{The user-provided instance identifier. If this parameter is specified,
information from only the specific instance is returned. This parameter
isn't case sensitive.

Constraints:
\itemize{
\item If provided, must match the identifier of an existing \code{DBInstance}.
}}

\item{Filters}{A filter that specifies one or more instances to describe.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts cluster identifiers and cluster Amazon
Resource Names (ARNs). The results list includes only the
information about the instances that are associated with the
clusters that are identified by these ARNs.
\item \code{db-instance-id} - Accepts instance identifiers and instance ARNs.
The results list includes only the information about the instances
that are identified by these ARNs.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  DBInstances = list(
    list(
      DBInstanceIdentifier = "string",
      DBInstanceClass = "string",
      Engine = "string",
      DBInstanceStatus = "string",
      Endpoint = list(
        Address = "string",
        Port = 123,
        HostedZoneId = "string"
      ),
      InstanceCreateTime = as.POSIXct(
        "2015-01-01"
      ),
      PreferredBackupWindow = "string",
      BackupRetentionPeriod = 123,
      VpcSecurityGroups = list(
        list(
          VpcSecurityGroupId = "string",
          Status = "string"
        )
      ),
      AvailabilityZone = "string",
      DBSubnetGroup = list(
        DBSubnetGroupName = "string",
        DBSubnetGroupDescription = "string",
        VpcId = "string",
        SubnetGroupStatus = "string",
        Subnets = list(
          list(
            SubnetIdentifier = "string",
            SubnetAvailabilityZone = list(
              Name = "string"
            ),
            SubnetStatus = "string"
          )
        ),
        DBSubnetGroupArn = "string"
      ),
      PreferredMaintenanceWindow = "string",
      PendingModifiedValues = list(
        DBInstanceClass = "string",
        AllocatedStorage = 123,
        MasterUserPassword = "string",
        Port = 123,
        BackupRetentionPeriod = 123,
        MultiAZ = TRUE|FALSE,
        EngineVersion = "string",
        LicenseModel = "string",
        Iops = 123,
        DBInstanceIdentifier = "string",
        StorageType = "string",
        CACertificateIdentifier = "string",
        DBSubnetGroupName = "string",
        PendingCloudwatchLogsExports = list(
          LogTypesToEnable = list(
            "string"
          ),
          LogTypesToDisable = list(
            "string"
          )
        )
      ),
      LatestRestorableTime = as.POSIXct(
        "2015-01-01"
      ),
      EngineVersion = "string",
      AutoMinorVersionUpgrade = TRUE|FALSE,
      PubliclyAccessible = TRUE|FALSE,
      StatusInfos = list(
        list(
          StatusType = "string",
          Normal = TRUE|FALSE,
          Status = "string",
          Message = "string"
        )
      ),
      DBClusterIdentifier = "string",
      StorageEncrypted = TRUE|FALSE,
      KmsKeyId = "string",
      DbiResourceId = "string",
      CACertificateIdentifier = "string",
      PromotionTier = 123,
      DBInstanceArn = "string",
      EnabledCloudwatchLogsExports = list(
        "string"
      )
    )
  )
)
}
}
\description{
Returns information about provisioned Amazon DocumentDB instances. This
API supports pagination.
}
\section{Request syntax}{
\preformatted{svc$describe_db_instances(
  DBInstanceIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
