% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_add_tags_to_resource}
\alias{neptune_add_tags_to_resource}
\title{Adds metadata tags to an Amazon Neptune resource}
\usage{
neptune_add_tags_to_resource(ResourceName, Tags)
}
\arguments{
\item{ResourceName}{[required] The Amazon Neptune resource that the tags are added to. This value is an
Amazon Resource Name (ARN). For information about creating an ARN, see
\href{https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing}{Constructing an Amazon Resource Name (ARN)}.}

\item{Tags}{[required] The tags to be assigned to the Amazon Neptune resource.}
}
\value{
An empty list.
}
\description{
Adds metadata tags to an Amazon Neptune resource. These tags can also be
used with cost allocation reporting to track cost associated with Amazon
Neptune resources, or used in a Condition statement in an IAM policy for
Amazon Neptune.
}
\section{Request syntax}{
\preformatted{svc$add_tags_to_resource(
  ResourceName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
