% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_db_cluster_parameter_groups}
\alias{neptune_describe_db_cluster_parameter_groups}
\title{Returns a list of DBClusterParameterGroup descriptions}
\usage{
neptune_describe_db_cluster_parameter_groups(
  DBClusterParameterGroupName, Filters, MaxRecords, Marker)
}
\arguments{
\item{DBClusterParameterGroupName}{The name of a specific DB cluster parameter group to return details for.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBClusterParameterGroups} request. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns a list of \code{DBClusterParameterGroup} descriptions. If a
\code{DBClusterParameterGroupName} parameter is specified, the list will
contain only the description of the specified DB cluster parameter
group.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_parameter_groups(
  DBClusterParameterGroupName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
