# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS RDS DataService
#'
#' @description
#' Amazon RDS Data Service
#' 
#' Amazon RDS provides an HTTP endpoint to run SQL statements on an Amazon
#' Aurora Serverless DB cluster. To run these statements, you work with the
#' Data Service API.
#' 
#' For more information about the Data Service API, see [Using the Data API
#' for Aurora
#' Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
#' in the *Amazon Aurora User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- rdsdataservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- rdsdataservice()
#' svc$batch_execute_statement(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=rdsdataservice_batch_execute_statement]{batch_execute_statement} \tab Runs a batch SQL statement over an array of data \cr
#'  \link[=rdsdataservice_begin_transaction]{begin_transaction} \tab Starts a SQL transaction \cr
#'  \link[=rdsdataservice_commit_transaction]{commit_transaction} \tab Ends a SQL transaction started with the BeginTransaction operation and commits the changes\cr
#'  \link[=rdsdataservice_execute_sql]{execute_sql} \tab Runs one or more SQL statements \cr
#'  \link[=rdsdataservice_execute_statement]{execute_statement} \tab Runs a SQL statement against a database \cr
#'  \link[=rdsdataservice_rollback_transaction]{rollback_transaction} \tab Performs a rollback of a transaction 
#' }
#'
#' @rdname rdsdataservice
#' @export
rdsdataservice <- function(config = list()) {
  svc <- .rdsdataservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.rdsdataservice <- list()

.rdsdataservice$operations <- list()

.rdsdataservice$metadata <- list(
  service_name = "rdsdataservice",
  endpoints = list("*" = list(endpoint = "rdsdataservice.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "rdsdataservice.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "RDS Data",
  api_version = "2018-08-01",
  signing_name = "rds-data",
  json_version = "1.1",
  target_prefix = ""
)

.rdsdataservice$handlers <- new_handlers("restjson", "v4")

.rdsdataservice$service <- function(config = list()) {
  new_service(.rdsdataservice$metadata, .rdsdataservice$handlers, config)
}
