% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_cluster}
\alias{neptune_modify_db_cluster}
\title{Modify a setting for a DB cluster}
\usage{
neptune_modify_db_cluster(DBClusterIdentifier, NewDBClusterIdentifier,
  ApplyImmediately, BackupRetentionPeriod, DBClusterParameterGroupName,
  VpcSecurityGroupIds, Port, MasterUserPassword, OptionGroupName,
  PreferredBackupWindow, PreferredMaintenanceWindow,
  EnableIAMDatabaseAuthentication, CloudwatchLogsExportConfiguration,
  EngineVersion)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the cluster being modified. This parameter
is not case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}}

\item{NewDBClusterIdentifier}{The new DB cluster identifier for the DB cluster when renaming a DB
cluster. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item The first character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-cluster2}}

\item{ApplyImmediately}{A value that specifies whether the modifications in this request and any
pending modifications are asynchronously applied as soon as possible,
regardless of the \code{PreferredMaintenanceWindow} setting for the DB
cluster. If this parameter is set to \code{false}, changes to the DB cluster
are applied during the next maintenance window.

The \code{ApplyImmediately} parameter only affects the
\code{NewDBClusterIdentifier} and \code{MasterUserPassword} values. If you set the
\code{ApplyImmediately} parameter value to false, then changes to the
\code{NewDBClusterIdentifier} and \code{MasterUserPassword} values are applied
during the next maintenance window. All other changes are applied
immediately, regardless of the value of the \code{ApplyImmediately}
parameter.

Default: \code{false}}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. You must
specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to use for the DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the DB cluster will belong to.}

\item{Port}{The port number on which the DB cluster accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{MasterUserPassword}{The new password for the master database user. This password can contain
any printable ASCII character except \"/\", \"\"\", or \"@\".

Constraints: Must contain from 8 to 41 characters.}

\item{OptionGroupName}{A value that indicates that the DB cluster should be associated with the
specified option group. Changing this parameter doesn\'t result in an
outage except in the following case, and the change is applied during
the next maintenance window unless the \code{ApplyImmediately} parameter is
set to \code{true} for this request. If the parameter change results in an
option group that enables OEM, this change can cause a brief
(sub-second) period during which new connections are rejected but
existing connections are not interrupted.

Permanent options can\'t be removed from an option group. The option
group can\'t be removed from a DB cluster once it is associated with a
DB cluster.}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region.

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week.

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

Default: \code{false}}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB cluster.}

\item{EngineVersion}{The version number of the database engine to which you want to upgrade.
Changing this parameter results in an outage. The change is applied
during the next maintenance window unless the ApplyImmediately parameter
is set to true.

For a list of valid engine versions, see CreateDBInstance, or call
DescribeDBEngineVersions.}
}
\description{
Modify a setting for a DB cluster. You can change one or more database
configuration parameters by specifying these parameters and the new
values in the request.
}
\section{Request syntax}{
\preformatted{svc$modify_db_cluster(
  DBClusterIdentifier = "string",
  NewDBClusterIdentifier = "string",
  ApplyImmediately = TRUE|FALSE,
  BackupRetentionPeriod = 123,
  DBClusterParameterGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Port = 123,
  MasterUserPassword = "string",
  OptionGroupName = "string",
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  CloudwatchLogsExportConfiguration = list(
    EnableLogTypes = list(
      "string"
    ),
    DisableLogTypes = list(
      "string"
    )
  ),
  EngineVersion = "string"
)
}
}

\keyword{internal}
