% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_parameters}
\alias{rds_describe_db_cluster_parameters}
\title{Returns the detailed parameter list for a particular DB cluster
parameter group}
\usage{
rds_describe_db_cluster_parameters(DBClusterParameterGroupName, Source,
  Filters, MaxRecords, Marker)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of a specific DB cluster parameter group to return parameter
details for.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{Source}{A value that indicates to return only parameters for a specific source.
Parameter sources can be \code{engine}, \code{service}, or \code{customer}.}

\item{Filters}{This parameter isn\'t currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBClusterParameters} request. If this parameter is specified,
the response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns the detailed parameter list for a particular DB cluster
parameter group.
}
\details{
For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_parameters(
  DBClusterParameterGroupName = "string",
  Source = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
