% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_create_global_cluster}
\alias{docdb_create_global_cluster}
\title{Creates an Amazon DocumentDB global cluster that can span multiple
multiple Amazon Web Services Regions}
\usage{
docdb_create_global_cluster(
  GlobalClusterIdentifier,
  SourceDBClusterIdentifier = NULL,
  Engine = NULL,
  EngineVersion = NULL,
  DeletionProtection = NULL,
  DatabaseName = NULL,
  StorageEncrypted = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] The cluster identifier of the new global cluster.}

\item{SourceDBClusterIdentifier}{The Amazon Resource Name (ARN) to use as the primary cluster of the
global cluster. This parameter is optional.}

\item{Engine}{The name of the database engine to be used for this cluster.}

\item{EngineVersion}{The engine version of the global cluster.}

\item{DeletionProtection}{The deletion protection setting for the new global cluster. The global
cluster can't be deleted when deletion protection is enabled.}

\item{DatabaseName}{The name for your database of up to 64 alpha-numeric characters. If you
do not provide a name, Amazon DocumentDB will not create a database in
the global cluster you are creating.}

\item{StorageEncrypted}{The storage encryption setting for the new global cluster.}
}
\description{
Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.

See \url{https://paws-r.github.io/docs/docdb/create_global_cluster.html} for full documentation.
}
\keyword{internal}
