% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_cache_engine_versions}
\alias{elasticache_describe_cache_engine_versions}
\title{Returns a list of the available cache engines and their versions}
\usage{
elasticache_describe_cache_engine_versions(
  Engine = NULL,
  EngineVersion = NULL,
  CacheParameterGroupFamily = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  DefaultOnly = NULL
)
}
\arguments{
\item{Engine}{The cache engine to return. Valid values: \code{memcached} | \code{redis}}

\item{EngineVersion}{The cache engine version to return.

Example: \verb{1.4.14}}

\item{CacheParameterGroupFamily}{The name of a specific cache parameter group family to return details
for.

Valid values are: \code{memcached1.4} | \code{memcached1.5} | \code{memcached1.6} |
\code{redis2.6} | \code{redis2.8} | \code{redis3.2} | \code{redis4.0} | \code{redis5.0} |
\code{redis6.x} | \code{redis6.2}

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}

\item{DefaultOnly}{If \code{true}, specifies that only the default version of the specified
engine or engine and major version combination is to be returned.}
}
\description{
Returns a list of the available cache engines and their versions.

See \url{https://paws-r.github.io/docs/elasticache/describe_cache_engine_versions.html} for full documentation.
}
\keyword{internal}
