% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_instance_automated_backup}
\alias{rds_delete_db_instance_automated_backup}
\title{Deletes automated backups using the DbiResourceId value of the source DB
instance or the Amazon Resource Name (ARN) of the automated backups}
\usage{
rds_delete_db_instance_automated_backup(
  DbiResourceId = NULL,
  DBInstanceAutomatedBackupsArn = NULL
)
}
\arguments{
\item{DbiResourceId}{The identifier for the source DB instance, which can't be changed and
which is unique to an Amazon Web Services Region.}

\item{DBInstanceAutomatedBackupsArn}{The Amazon Resource Name (ARN) of the automated backups to delete, for
example,
\code{arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE}.

This setting doesn't apply to RDS Custom.}
}
\description{
Deletes automated backups using the \code{DbiResourceId} value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.

See \url{https://paws-r.github.io/docs/rds/delete_db_instance_automated_backup.html} for full documentation.
}
\keyword{internal}
