% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpledb_operations.R
\name{simpledb_get_attributes}
\alias{simpledb_get_attributes}
\title{Returns all of the attributes associated with the specified item}
\usage{
simpledb_get_attributes(
  DomainName,
  ItemName,
  AttributeNames = NULL,
  ConsistentRead = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain in which to perform the operation.}

\item{ItemName}{[required] The name of the item.}

\item{AttributeNames}{The names of the attributes.}

\item{ConsistentRead}{Determines whether or not strong consistency should be enforced when
data is read from SimpleDB. If \code{true}, any data previously written to
SimpleDB will be returned. Otherwise, results will be consistent
eventually, and the client may not see data that was written immediately
before your read.}
}
\description{
Returns all of the attributes associated with the specified item. Optionally, the attributes returned can be limited to one or more attributes by specifying an attribute name parameter.

See \url{https://paws-r.github.io/docs/simpledb/get_attributes.html} for full documentation.
}
\keyword{internal}
