% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_blue_green_deployments}
\alias{rds_describe_blue_green_deployments}
\title{Returns information about blue/green deployments}
\usage{
rds_describe_blue_green_deployments(
  BlueGreenDeploymentIdentifier = NULL,
  Filters = NULL,
  Marker = NULL,
  MaxRecords = NULL
)
}
\arguments{
\item{BlueGreenDeploymentIdentifier}{The blue/green deployment identifier. If this parameter is specified,
information from only the specific blue/green deployment is returned.
This parameter isn't case-sensitive.

Constraints:
\itemize{
\item If supplied, must match an existing blue/green deployment
identifier.
}}

\item{Filters}{A filter that specifies one or more blue/green deployments to describe.

Supported filters:
\itemize{
\item \code{blue-green-deployment-identifier} - Accepts system-generated
identifiers for blue/green deployments. The results list only
includes information about the blue/green deployments with the
specified identifiers.
\item \code{blue-green-deployment-name} - Accepts user-supplied names for
blue/green deployments. The results list only includes information
about the blue/green deployments with the specified names.
\item \code{source} - Accepts source databases for a blue/green deployment. The
results list only includes information about the blue/green
deployments with the specified source databases.
\item \code{target} - Accepts target databases for a blue/green deployment. The
results list only includes information about the blue/green
deployments with the specified target databases.
}}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_blue_green_deployments]{describe_blue_green_deployments}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}
}
\description{
Returns information about blue/green deployments.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_blue_green_deployments/} for full documentation.
}
\keyword{internal}
