% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_cache_clusters}
\alias{elasticache_describe_cache_clusters}
\title{Returns information about all provisioned clusters if no cluster
identifier is specified, or about a specific cache cluster if a cluster
identifier is supplied}
\usage{
elasticache_describe_cache_clusters(
  CacheClusterId = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  ShowCacheNodeInfo = NULL,
  ShowCacheClustersNotInReplicationGroups = NULL
)
}
\arguments{
\item{CacheClusterId}{The user-supplied cluster identifier. If this parameter is specified,
only information about that specific cluster is returned. This parameter
isn't case sensitive.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}

\item{ShowCacheNodeInfo}{An optional flag that can be included in the \code{DescribeCacheCluster}
request to retrieve information about the individual cache nodes.}

\item{ShowCacheClustersNotInReplicationGroups}{An optional flag that can be included in the \code{DescribeCacheCluster}
request to show only nodes (API/CLI: clusters) that are not members of a
replication group. In practice, this mean Memcached and single node
Redis clusters.}
}
\description{
Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.

See \url{https://www.paws-r-sdk.com/docs/elasticache_describe_cache_clusters/} for full documentation.
}
\keyword{internal}
