% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_promote_read_replica}
\alias{rds_promote_read_replica}
\title{Promotes a read replica DB instance to a standalone DB instance}
\usage{
rds_promote_read_replica(
  DBInstanceIdentifier,
  BackupRetentionPeriod = NULL,
  PreferredBackupWindow = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must match the identifier of an existing read replica DB instance.
}

Example: \code{mydbinstance}}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. Setting
this parameter to a positive number enables backups. Setting this
parameter to 0 disables automated backups.

Default: 1

Constraints:
\itemize{
\item Must be a value from 0 to 35.
\item Can't be set to 0 if the DB instance is a source to read replicas.
}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Web Services Region. To see the time
blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html}{Adjusting the Preferred Maintenance Window}
in the \emph{Amazon RDS User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}
}
\description{
Promotes a read replica DB instance to a standalone DB instance.

See \url{https://www.paws-r-sdk.com/docs/rds_promote_read_replica/} for full documentation.
}
\keyword{internal}
