# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS CodeDeploy
#'
#' @description
#' AWS CodeDeploy is a deployment service that automates application
#' deployments to Amazon EC2 instances, on-premises instances running in
#' your own facility, serverless AWS Lambda functions, or applications in
#' an Amazon ECS service.
#' 
#' You can deploy a nearly unlimited variety of application content, such
#' as an updated Lambda function, updated applications in an Amazon ECS
#' service, code, web and configuration files, executables, packages,
#' scripts, multimedia files, and so on. AWS CodeDeploy can deploy
#' application content stored in Amazon S3 buckets, GitHub repositories, or
#' Bitbucket repositories. You do not need to make changes to your existing
#' code before you can use AWS CodeDeploy.
#' 
#' AWS CodeDeploy makes it easier for you to rapidly release new features,
#' helps you avoid downtime during application deployment, and handles the
#' complexity of updating your applications, without many of the risks
#' associated with error-prone manual deployments.
#' 
#' **AWS CodeDeploy Components**
#' 
#' Use the information in this guide to help you work with the following
#' AWS CodeDeploy components:
#' 
#' -   **Application**: A name that uniquely identifies the application you
#'     want to deploy. AWS CodeDeploy uses this name, which functions as a
#'     container, to ensure the correct combination of revision, deployment
#'     configuration, and deployment group are referenced during a
#'     deployment.
#' 
#' -   **Deployment group**: A set of individual instances, CodeDeploy
#'     Lambda deployment configuration settings, or an Amazon ECS service
#'     and network details. A Lambda deployment group specifies how to
#'     route traffic to a new version of a Lambda function. An Amazon ECS
#'     deployment group specifies the service created in Amazon ECS to
#'     deploy, a load balancer, and a listener to reroute production
#'     traffic to an updated containerized application. An EC2/On-premises
#'     deployment group contains individually tagged instances, Amazon EC2
#'     instances in Amazon EC2 Auto Scaling groups, or both. All deployment
#'     groups can specify optional trigger, alarm, and rollback settings.
#' 
#' -   **Deployment configuration**: A set of deployment rules and
#'     deployment success and failure conditions used by AWS CodeDeploy
#'     during a deployment.
#' 
#' -   **Deployment**: The process and the components used when updating a
#'     Lambda function, a containerized application in an Amazon ECS
#'     service, or of installing content on one or more instances.
#' 
#' -   **Application revisions**: For an AWS Lambda deployment, this is an
#'     AppSpec file that specifies the Lambda function to be updated and
#'     one or more functions to validate deployment lifecycle events. For
#'     an Amazon ECS deployment, this is an AppSpec file that specifies the
#'     Amazon ECS task definition, container, and port where production
#'     traffic is rerouted. For an EC2/On-premises deployment, this is an
#'     archive file that contains source content—source code, webpages,
#'     executable files, and deployment scripts—along with an AppSpec file.
#'     Revisions are stored in Amazon S3 buckets or GitHub repositories.
#'     For Amazon S3, a revision is uniquely identified by its Amazon S3
#'     object key and its ETag, version, or both. For GitHub, a revision is
#'     uniquely identified by its commit ID.
#' 
#' This guide also contains information to help you get details about the
#' instances in your deployments, to make on-premises instances available
#' for AWS CodeDeploy deployments, to get details about a Lambda function
#' deployment, and to get details about Amazon ECS service deployments.
#' 
#' **AWS CodeDeploy Information Resources**
#' 
#' -   [AWS CodeDeploy User
#'     Guide](https://docs.aws.amazon.com/codedeploy/latest/userguide/)
#' 
#' -   [AWS CodeDeploy API Reference
#'     Guide](https://docs.aws.amazon.com/codedeploy/latest/APIReference/)
#' 
#' -   [AWS CLI Reference for AWS
#'     CodeDeploy](https://docs.aws.amazon.com/cli/latest/reference/deploy/index.html)
#' 
#' -   [AWS CodeDeploy Developer
#'     Forum](https://forums.aws.amazon.com/forum.jspa?forumID=179)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- codedeploy(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- codedeploy()
#' svc$add_tags_to_on_premises_instances(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=codedeploy_add_tags_to_on_premises_instances]{add_tags_to_on_premises_instances} \tab Adds tags to on-premises instances\cr
#'  \link[=codedeploy_batch_get_application_revisions]{batch_get_application_revisions} \tab Gets information about one or more application revisions\cr
#'  \link[=codedeploy_batch_get_applications]{batch_get_applications} \tab Gets information about one or more applications\cr
#'  \link[=codedeploy_batch_get_deployment_groups]{batch_get_deployment_groups} \tab Gets information about one or more deployment groups\cr
#'  \link[=codedeploy_batch_get_deployment_instances]{batch_get_deployment_instances} \tab This method works, but is deprecated\cr
#'  \link[=codedeploy_batch_get_deployments]{batch_get_deployments} \tab Gets information about one or more deployments\cr
#'  \link[=codedeploy_batch_get_deployment_targets]{batch_get_deployment_targets} \tab Returns an array of one or more targets associated with a deployment\cr
#'  \link[=codedeploy_batch_get_on_premises_instances]{batch_get_on_premises_instances} \tab Gets information about one or more on-premises instances\cr
#'  \link[=codedeploy_continue_deployment]{continue_deployment} \tab For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse\cr
#'  \link[=codedeploy_create_application]{create_application} \tab Creates an application\cr
#'  \link[=codedeploy_create_deployment]{create_deployment} \tab Deploys an application revision through the specified deployment group\cr
#'  \link[=codedeploy_create_deployment_config]{create_deployment_config} \tab Creates a deployment configuration\cr
#'  \link[=codedeploy_create_deployment_group]{create_deployment_group} \tab Creates a deployment group to which application revisions are deployed\cr
#'  \link[=codedeploy_delete_application]{delete_application} \tab Deletes an application\cr
#'  \link[=codedeploy_delete_deployment_config]{delete_deployment_config} \tab Deletes a deployment configuration\cr
#'  \link[=codedeploy_delete_deployment_group]{delete_deployment_group} \tab Deletes a deployment group\cr
#'  \link[=codedeploy_delete_git_hub_account_token]{delete_git_hub_account_token} \tab Deletes a GitHub account connection\cr
#'  \link[=codedeploy_delete_resources_by_external_id]{delete_resources_by_external_id} \tab Deletes resources linked to an external ID\cr
#'  \link[=codedeploy_deregister_on_premises_instance]{deregister_on_premises_instance} \tab Deregisters an on-premises instance\cr
#'  \link[=codedeploy_get_application]{get_application} \tab Gets information about an application\cr
#'  \link[=codedeploy_get_application_revision]{get_application_revision} \tab Gets information about an application revision\cr
#'  \link[=codedeploy_get_deployment]{get_deployment} \tab Gets information about a deployment\cr
#'  \link[=codedeploy_get_deployment_config]{get_deployment_config} \tab Gets information about a deployment configuration\cr
#'  \link[=codedeploy_get_deployment_group]{get_deployment_group} \tab Gets information about a deployment group\cr
#'  \link[=codedeploy_get_deployment_instance]{get_deployment_instance} \tab Gets information about an instance as part of a deployment\cr
#'  \link[=codedeploy_get_deployment_target]{get_deployment_target} \tab Returns information about a deployment target\cr
#'  \link[=codedeploy_get_on_premises_instance]{get_on_premises_instance} \tab Gets information about an on-premises instance\cr
#'  \link[=codedeploy_list_application_revisions]{list_application_revisions} \tab Lists information about revisions for an application\cr
#'  \link[=codedeploy_list_applications]{list_applications} \tab Lists the applications registered with the IAM user or AWS account\cr
#'  \link[=codedeploy_list_deployment_configs]{list_deployment_configs} \tab Lists the deployment configurations with the IAM user or AWS account\cr
#'  \link[=codedeploy_list_deployment_groups]{list_deployment_groups} \tab Lists the deployment groups for an application registered with the IAM user or AWS account\cr
#'  \link[=codedeploy_list_deployment_instances]{list_deployment_instances} \tab The newer BatchGetDeploymentTargets should be used instead because it works with all compute types\cr
#'  \link[=codedeploy_list_deployments]{list_deployments} \tab Lists the deployments in a deployment group for an application registered with the IAM user or AWS account\cr
#'  \link[=codedeploy_list_deployment_targets]{list_deployment_targets} \tab Returns an array of target IDs that are associated a deployment\cr
#'  \link[=codedeploy_list_git_hub_account_token_names]{list_git_hub_account_token_names} \tab Lists the names of stored connections to GitHub accounts\cr
#'  \link[=codedeploy_list_on_premises_instances]{list_on_premises_instances} \tab Gets a list of names for one or more on-premises instances\cr
#'  \link[=codedeploy_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN)\cr
#'  \link[=codedeploy_put_lifecycle_event_hook_execution_status]{put_lifecycle_event_hook_execution_status} \tab Sets the result of a Lambda validation function\cr
#'  \link[=codedeploy_register_application_revision]{register_application_revision} \tab Registers with AWS CodeDeploy a revision for the specified application\cr
#'  \link[=codedeploy_register_on_premises_instance]{register_on_premises_instance} \tab Registers an on-premises instance\cr
#'  \link[=codedeploy_remove_tags_from_on_premises_instances]{remove_tags_from_on_premises_instances} \tab Removes one or more tags from one or more on-premises instances\cr
#'  \link[=codedeploy_skip_wait_time_for_instance_termination]{skip_wait_time_for_instance_termination} \tab In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete\cr
#'  \link[=codedeploy_stop_deployment]{stop_deployment} \tab Attempts to stop an ongoing deployment\cr
#'  \link[=codedeploy_tag_resource]{tag_resource} \tab Associates the list of tags in the input Tags parameter with the resource identified by the ResourceArn input parameter\cr
#'  \link[=codedeploy_untag_resource]{untag_resource} \tab Disassociates a resource from a list of tags\cr
#'  \link[=codedeploy_update_application]{update_application} \tab Changes the name of an application\cr
#'  \link[=codedeploy_update_deployment_group]{update_deployment_group} \tab Changes information about a deployment group
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname codedeploy
#' @export
codedeploy <- function(config = list()) {
  svc <- .codedeploy$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.codedeploy <- list()

.codedeploy$operations <- list()

.codedeploy$metadata <- list(
  service_name = "codedeploy",
  endpoints = list("*" = list(endpoint = "codedeploy.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "codedeploy.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "codedeploy.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "codedeploy.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CodeDeploy",
  api_version = "2014-10-06",
  signing_name = "codedeploy",
  json_version = "1.1",
  target_prefix = "CodeDeploy_20141006"
)

.codedeploy$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.codedeploy$metadata, handlers, config)
}
