% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_create_pull_request}
\alias{codecommit_create_pull_request}
\title{Creates a pull request in the specified repository}
\usage{
codecommit_create_pull_request(title, description, targets,
  clientRequestToken)
}
\arguments{
\item{title}{[required] The title of the pull request. This title is used to identify the pull
request to other users in the repository.}

\item{description}{A description of the pull request.}

\item{targets}{[required] The targets for the pull request, including the source of the code to be
reviewed (the source branch) and the destination where the creator of
the pull request intends the code to be merged after the pull request is
closed (the destination branch).}

\item{clientRequestToken}{A unique, client-generated idempotency token that, when provided in a
request, ensures the request cannot be repeated with a changed
parameter. If a request is received with the same parameters and a token
is included, the request returns information about the initial request
that used that token.

The AWS SDKs prepopulate client request tokens. If you are using an AWS
SDK, an idempotency token is created for you.}
}
\value{
A list with the following syntax:\preformatted{list(
  pullRequest = list(
    pullRequestId = "string",
    title = "string",
    description = "string",
    lastActivityDate = as.POSIXct(
      "2015-01-01"
    ),
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    pullRequestStatus = "OPEN"|"CLOSED",
    authorArn = "string",
    pullRequestTargets = list(
      list(
        repositoryName = "string",
        sourceReference = "string",
        destinationReference = "string",
        destinationCommit = "string",
        sourceCommit = "string",
        mergeBase = "string",
        mergeMetadata = list(
          isMerged = TRUE|FALSE,
          mergedBy = "string",
          mergeCommitId = "string",
          mergeOption = "FAST_FORWARD_MERGE"|"SQUASH_MERGE"|"THREE_WAY_MERGE"
        )
      )
    ),
    clientRequestToken = "string",
    revisionId = "string",
    approvalRules = list(
      list(
        approvalRuleId = "string",
        approvalRuleName = "string",
        approvalRuleContent = "string",
        ruleContentSha256 = "string",
        lastModifiedDate = as.POSIXct(
          "2015-01-01"
        ),
        creationDate = as.POSIXct(
          "2015-01-01"
        ),
        lastModifiedUser = "string",
        originApprovalRuleTemplate = list(
          approvalRuleTemplateId = "string",
          approvalRuleTemplateName = "string"
        )
      )
    )
  )
)
}
}
\description{
Creates a pull request in the specified repository.
}
\section{Request syntax}{
\preformatted{svc$create_pull_request(
  title = "string",
  description = "string",
  targets = list(
    list(
      repositoryName = "string",
      sourceReference = "string",
      destinationReference = "string"
    )
  ),
  clientRequestToken = "string"
)
}
}

\keyword{internal}
