% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_comments_for_compared_commit}
\alias{codecommit_get_comments_for_compared_commit}
\title{Returns information about comments made on the comparison between two
commits}
\usage{
codecommit_get_comments_for_compared_commit(repositoryName,
  beforeCommitId, afterCommitId, nextToken, maxResults)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to compare commits.}

\item{beforeCommitId}{To establish the directionality of the comparison, the full commit ID of
the before commit.}

\item{afterCommitId}{[required] To establish the directionality of the comparison, the full commit ID of
the after commit.}

\item{nextToken}{An enumeration token that when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results. The default is 100 comments, but you can configure up to 500.}
}
\value{
A list with the following syntax:\preformatted{list(
  commentsForComparedCommitData = list(
    list(
      repositoryName = "string",
      beforeCommitId = "string",
      afterCommitId = "string",
      beforeBlobId = "string",
      afterBlobId = "string",
      location = list(
        filePath = "string",
        filePosition = 123,
        relativeFileVersion = "BEFORE"|"AFTER"
      ),
      comments = list(
        list(
          commentId = "string",
          content = "string",
          inReplyTo = "string",
          creationDate = as.POSIXct(
            "2015-01-01"
          ),
          lastModifiedDate = as.POSIXct(
            "2015-01-01"
          ),
          authorArn = "string",
          deleted = TRUE|FALSE,
          clientRequestToken = "string",
          callerReactions = list(
            "string"
          ),
          reactionCounts = list(
            123
          )
        )
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns information about comments made on the comparison between two
commits.

Reaction counts might include numbers from user identities who were
deleted after the reaction was made. For a count of reactions from
active identities, use GetCommentReactions.
}
\section{Request syntax}{
\preformatted{svc$get_comments_for_compared_commit(
  repositoryName = "string",
  beforeCommitId = "string",
  afterCommitId = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
