% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_list_repositories_for_approval_rule_template}
\alias{codecommit_list_repositories_for_approval_rule_template}
\title{Lists all repositories associated with the specified approval rule
template}
\usage{
codecommit_list_repositories_for_approval_rule_template(
  approvalRuleTemplateName, nextToken, maxResults)
}
\arguments{
\item{approvalRuleTemplateName}{[required] The name of the approval rule template for which you want to list
repositories that are associated with that template.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results.}
}
\value{
A list with the following syntax:\preformatted{list(
  repositoryNames = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Lists all repositories associated with the specified approval rule
template.
}
\section{Request syntax}{
\preformatted{svc$list_repositories_for_approval_rule_template(
  approvalRuleTemplateName = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
